// main.c
// Evan Lord
// Created: July 10, 2007
// Last Modified: July 10, 2007


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <mcheck.h>
#include "constants.h"
#include "struct_def.h"

double pow(double, double);

float CalculateError(struct DATA *);
void CreateSuperPoints(struct DATA *);
float Distance(float *, float *, int);
struct DATA * InitializeCentroids(struct DATA *);
int Kmeans(struct DATA *);
void MLClosure(struct DATA *);
void Normalize(struct DATA *);
void PrintData(struct DATA *);
void ReadConstraints(char *, struct DATA *);
void ReadData(char *, char *, struct DATA *);
void ReadNames(char *, struct DATA *);
float SuperDistance(struct SUPER_POINT *, float *, int, float **);
void SuperPointConstraints(struct DATA *);
void UpdateConstraints(struct SUPER_POINT *, struct DATA *);
int ViolateConstraints(struct SUPER_POINT *, int, struct DATA *);
void WriteResults(struct DATA *);


int main(int argc, char * argv[])
{
  
  int int_loop;
  float flt_avg_error;

  struct DATA * data;
 
  char * temp_one;
  char * temp_two;
  char chr_temp;
  int int_temp;
  int int_length;

  int int_success;
  int int_kmeans_type;

  int total_ML;
  int satisfied_ML;
  int total_CL;
  int satisfied_CL;

  int int_factor;
  int int_random_seed = 0;

  //mtrace();

  int_kmeans_type = 0;
  total_ML = 0;
  satisfied_ML = 0;
  total_CL = 0;
  satisfied_CL = 0;

  if(argc == 4){
    temp_one = argv[3];
  }
  else if(argc == 5){
    temp_one = argv[3];
    temp_two = argv[4];
  }
  else if(argc == 6){
    temp_one = argv[5];

    if(!strcmp(argv[4], "-COP")){
      int_kmeans_type = 1;
    }
    else if(!strcmp(argv[4], "-CVQE")){
      int_kmeans_type = 2;
    }
    else if(!strcmp(argv[4], "-LCVQE")){
      int_kmeans_type = 3;
    }
  }
  else if(argc == 7){
    temp_one = argv[5];
    temp_two = argv[6];
    
    if(!strcmp(argv[4], "-COP")){
      int_kmeans_type = 1;
    }
    else if(!strcmp(argv[4], "-CVQE")){
      int_kmeans_type = 2;
    }
    else if(!strcmp(argv[4], "-LCVQE")){
      int_kmeans_type = 3;
    }
  }
  else{
    fprintf(stderr, "\nUsage:\t%s <names file> <data file> <k>\n\t%s <names file> <data file> <constraints file> -COP <k>\n\t%s <names file> <data file> <constraints file> -CVQE <k>\n\t%s <names file> <data file> <constraints file> -LCVQE <k>\n\n", argv[0], argv[0], argv[0], argv[0]);
    exit(1);
  }
    
 
  // allocate memory for the DATA struct
  if((data = (struct DATA *)malloc(sizeof(struct DATA))) == NULL){
    fprintf(stderr, "\nMemory allocation error.  Closing program.\n\n");
    exit(1);
  }
  else{
    data->int_algorithm_version = int_kmeans_type;
    
    // convert string numbers into integers
    int_factor = 1;
    int_length = strlen(temp_one);
    for(int_loop = 1; int_loop <= int_length; int_loop++){
      chr_temp = temp_one[int_length - int_loop];
      int_temp = chr_temp - ASCII_ZERO;
      data->int_num_clusters = data->int_num_clusters + int_temp * int_factor;
      int_factor = int_factor * 10;
    }

    if((argc == 5) || (argc == 7)){
      int_factor = 1;
      int_length = strlen(temp_two);
      for(int_loop = 1; int_loop <= int_length; int_loop++){
	chr_temp = temp_two[int_length - int_loop];
	int_temp = chr_temp - ASCII_ZERO;
	int_random_seed = int_random_seed + int_temp * int_factor;
	int_factor = int_factor * 10;
      }
      printf("\n\nRandom Seed: %d\n\n", int_random_seed);    

      srand(int_random_seed);
    }
    else{
      srand(time(0));
    }
  
    // call function to read names file
    ReadNames(argv[1], data);   
    
    // call function to read data file
    ReadData(argv[2], data->str_names, data);
    
    //PrintData(data);
    
    // call function to normalize the data
    Normalize(data);
    
    flt_avg_error = 0;
    
    // call function to perform k-means algorithm
    if(int_kmeans_type == 0){
      printf("\nNormal K-Means\n");
      printf("%d Clusters\n", data->int_num_clusters);
      
      //PrintData(data);
      
      CreateSuperPoints(data);
      
      for(int_loop = 0; int_loop < REPEAT; int_loop++){
	InitializeCentroids(data);
	Kmeans(data);
	flt_avg_error = flt_avg_error + CalculateError(data);
      }
      
      //PrintData(data);
      
      printf("\nError: %f\n\n", flt_avg_error/REPEAT);
      
    }
    else{
      if(int_kmeans_type == 1){
	printf("\nCOP-K-Means\n");
	printf("%d Clusters\n", data->int_num_clusters);
	ReadConstraints(argv[3], data);
	MLClosure(data);
	//SuperPointConstraints(data);
	
	for(int_loop = 0; int_loop < REPEAT; int_loop++){
	  int_success = 0;
	  while(!int_success){
	    //printf(".\n");
	    InitializeCentroids(data);	  
	    int_success = Kmeans(data);
	  }
	  
	  total_ML = total_ML + data->int_num_ML_constraints;
	  total_CL = total_CL + data->int_num_CL_constraints;
	  satisfied_ML = satisfied_ML + data->int_num_ML_satisfied;
	  satisfied_CL = satisfied_CL + data->int_num_CL_satisfied;
	  flt_avg_error = flt_avg_error + CalculateError(data);
	}
	
	//PrintData(data);
	
	printf("\nError: %f\nPercent ML satisfied: %f\nPercent CL satisfied: %f\nPercent combined satisfied: %f\n\n", flt_avg_error/REPEAT, 100*(float)satisfied_ML/(float)total_ML, 100*(float)satisfied_CL/(float)total_CL, 100*((float)satisfied_ML+(float)satisfied_CL)/((float)total_ML+(float)total_CL));
	
      }
      else{
	if(int_kmeans_type == 2){
	  printf("\nCVQE-K-Means\n");
	  printf("%d Clusters\n", data->int_num_clusters);
	  ReadConstraints(argv[3], data);
	  CreateSuperPoints(data);
	  
	  for(int_loop = 0; int_loop < REPEAT; int_loop++){
	    InitializeCentroids(data);
	    Kmeans(data);
	    
	    total_ML = total_ML + data->int_num_ML_constraints;
	    total_CL = total_CL + data->int_num_CL_constraints;
	    satisfied_ML = satisfied_ML + data->int_num_ML_satisfied;
	    satisfied_CL = satisfied_CL + data->int_num_CL_satisfied;
	    flt_avg_error = flt_avg_error + CalculateError(data);
	  }
	  
	  //PrintData(data);
	  
	  printf("\nError: %f\nPercent ML satisfied: %f\nPercent CL satisfied: %f\nPercent combined satisfied: %f\n\n", flt_avg_error/REPEAT, 100*(float)satisfied_ML/(float)total_ML, 100*(float)satisfied_CL/(float)total_CL, 100*((float)satisfied_ML+(float)satisfied_CL)/((float)total_ML+(float)total_CL));
	}
	else{
	  if(int_kmeans_type == 3){
	    printf("\nLCVQE-K-Means\n");
	    printf("%d Clusters\n", data->int_num_clusters);
	    ReadConstraints(argv[3], data);
	    CreateSuperPoints(data);
	    
	    for(int_loop = 0; int_loop < REPEAT; int_loop++){
	      InitializeCentroids(data);
	      Kmeans(data);
	      
	      total_ML = total_ML + data->int_num_ML_constraints;
	      total_CL = total_CL + data->int_num_CL_constraints;
	      satisfied_ML = satisfied_ML + data->int_num_ML_satisfied;
	      satisfied_CL = satisfied_CL + data->int_num_CL_satisfied;
	      flt_avg_error = flt_avg_error + CalculateError(data);
	    }
	    
	    //PrintData(data);
	    
	    printf("\nError: %f\nPercent ML satisfied: %f\nPercent CL satisfied: %f\nPercent combined satisfied: %f\n\n", flt_avg_error/REPEAT, 100*(float)satisfied_ML/(float)total_ML, 100*(float)satisfied_CL/(float)total_CL, 100*((float)satisfied_ML+(float)satisfied_CL)/((float)total_ML+(float)total_CL));
	  }
	  else{
	    fprintf(stderr, "\n\nError.\n\n");
	  }
	}
      }
    }
    
    // call function to write the centroid coordinates
    // and the cluster assignments to files
    WriteResults(data);
    
  }  

  return 0;
}

