#define SAFE_FILES	{ string {lexical_cst "\"/dev/null\""} }
#define UNSAFE_FILES	{ not SAFE_FILES }
#define __OPEN(fname)	{ function_call {identifier open} fname {ellipsis} }
#define __FOPEN(fname)	{ function_call {identifier fopen} fname {any} }
#define OPEN(fname)	{ or __OPEN(fname) __FOPEN(fname) }
#define CLOSE(fd)	{ function_call {identifier close} fd }
#define FCLOSE(file)	{ function_call {identifier fclose} file }
#define CLOSE_STDIN	{or CLOSE({lexical_cst 0}) FCLOSE({identifier stdin})}
#define CLOSE_STDOUT	{or CLOSE({lexical_cst 1}) FCLOSE({identifier stdout})}
#define CLOSE_STDERR	{or CLOSE({lexical_cst 2}) FCLOSE({identifier stderr})}
#define DUP(oldd)	{ function_call {identifier dup} oldd }
#define DUP2(oldd,newd)	{ function_call {identifier dup2} oldd newd }
#define PIPE		{ function_call {identifier pipe} {any} }
#define DEFAULT		{ other }
