// $Id: CfgText2Bin.java,v 1.5 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import gnu.getopt.*;

/**
 * Convert a CFG from text to binary format
 */
public class CfgText2Bin
{
  static final String optionString = "i:o:" + Util.getOptionString(),
    optionUsage =
    "Usage: CfgText2Bin [options]\n" +
    "Options:\n" +
    "  -i <file>\tRead the input from <file>\n" +
    "  -o <file>\tWrite the output to <file>\n" +
    Util.getOptionUsage();
  
  public static void main(String args[]) throws IOException
  {
    Cfg cfg = new Cfg();
    String inputFileName = "-", outputFileName = "-";
    Getopt opt;
    int ch;

    opt = new Getopt("Cfg2Dot", args, optionString, Util.getLongOpts());
    while ((ch = opt.getopt()) != -1)
    {
      switch(ch)
      {
	case 'i':
	  inputFileName = opt.getOptarg();
	  break;
	  
	case 'o':
	  outputFileName = opt.getOptarg();
	  break;
	  
	default:
	  Util.processOption(ch, opt, optionUsage);
      }
    }
    if ((args.length - opt.getOptind()) != 0)
    {
      Util.stderr.println(optionUsage);
      System.exit(1);
    }
    cfg.read(inputFileName, false);
    cfg.write(outputFileName, true, null);
  }
}
