// $Id: FsaTransition.java,v 1.9 2003/09/22 21:31:56 hchen Exp $

import java.util.*;

/**
 * Represents a transition in FSA
 */
public class FsaTransition implements Record
{
  // Note the order of these fields are important, as it determines
  // the value of hashCode(BitSet)
  public int state0;
  public Object input;
  public int state1;
  
  public FsaTransition()
  {
    state0 = 0;
    input = null;
    state1 = 0;
  }

  public FsaTransition(int state0, Object input, int state1)
  {
    this.state0 = state0;
    this.input = input;
    this.state1 = state1;
  }

  /**
   * This is used by PolyHashtable to determine if two records are identical.
   * Note: this does not override Object.equals(Object), so it does not
   * affect Hashtable or HashSet.  This is also used by ExplicitEdge.equals().
   *
   * IMPORTANT: the parameter must be declared as Record, NOT FsaTransition!
   * Two FsaTransition a and b are equal if all of the followings are true:
   * <ul>
   * <li> (a.input == null && b.input == null)
   *   || (a.input != null && b.input != null && a.input.equals(b.input) </li>
   * <li> a.state0 == b.state0 </li>
   * <li> a.state1 == b.state1 </li>
   * </ul>
   */
  public boolean equals(Record record)
  {
    FsaTransition t = (FsaTransition)record;

    if (t.input == null)
    {
      if (this.input != null)
	return false;
    }
    else
    {
      if (this.input == null)
	return false;
      else if (!t.input.equals(this.input))
	return false;
    }
    return t.state0 == this.state0 && t.state1 == this.state1;
  }

  public boolean matches(Record record, BitSet fields)
  {
    FsaTransition t = (FsaTransition)record;
    
    return ((!fields.get(0) || t.state0 == state0) &&
	    (!fields.get(1) || t.input.equals(input)) &&
	    (!fields.get(2) || t.state1 == state1));
  }
  
  /**
   * Creates a new FsaTransition with an additional dimension
   */
  public FsaTransition expand(int newState0, int newState1, int dim)
  {
    return new FsaTransition(newState0 * dim + state0, input,
			     newState1 * dim + state1);
  }

  /**
   * Used by PolyHashtable
   */
  public int hashCode(BitSet fields)
  {
    int value, shift, mask;
    
    if (Util.isDebug() && fields.length() > 3)
      Util.die(Util.INTERNAL, "Max index >= 3 when indexing FsaTransition objects");
    shift = 32 / fields.cardinality();
    mask = (int)(1L << shift) - 1;
    value = 0;
    if (fields.get(0))
      value = (value << shift) + (state0 & mask);
    if (fields.get(1))
      value = (value << shift) + (input.hashCode() & mask);
    if (fields.get(2))
      value = (value << shift) + (state1 & mask);

    return value;
  }

  public static final int EPSILON = 0;
}
