// $Id: BinaryOutput.java,v 1.4 2003/05/11 22:31:33 hchen Exp $

import java.io.*;

class BinaryOutput extends Output
{
  DataOutputStream dos;

  public BinaryOutput(BufferedOutputStream os)
  {
    this.dos = new DataOutputStream(os);
  }

  public void writeToken(int token) throws IOException
  {
    if (token < 0 || token > Constants.MAX_TOKEN)
      throw new IOException("Token value out of range: " + token);
    dos.writeByte((byte)(token & 0xff));
    if (token == Constants.EOF)
      flush();
  }

  public void writeByte(int value) throws IOException
  {
    writeToken(Constants.BYTE);
    dos.writeByte((byte)(value & 0xff));
  }
  
  public void writeInt(int value) throws IOException
  {
    int i;
    
    writeToken(Constants.INT);
    dos.writeInt(value);
  }

  public void writeString(String str) throws IOException
  {
    // Bother. We really ought to do this with UTF, but the rc pass
    // uses ASCII, so we need to do it using bytes. Damn nuisance.
    writeToken(Constants.STRING);
    dos.writeInt(str.length());
    dos.writeBytes(str);
  }

  public void flush() throws IOException
  {
    dos.flush();
  }
  
  public void close() throws IOException
  {
    // writeToken(Constants.EOF);
    dos.close();
  }
}
