// $Id: Node.java,v 1.9 2003/09/22 21:31:57 hchen Exp $

import java.io.*;
import java.util.*;

/**
 * Represent a node in the CFG
 */
public class Node implements ShortestPathNode
{
  public Node()
  {
    this(null, null);
  }

  public Node(Vector inEdges, Vector outEdges)
  {
    ShortestPathNode(inEdges, outEdges);
    label = null;
    sequenceNumber = 0;
    address = 0;
    done = classDone;
  }

  public final void setAddress(int address)
  {
    this.address = address;
  }

  public final int getAddress()
  {
    return address;
  }
  
  public final void setLabel(Object label)
  {
    this.label = label;
  }

  // Used by Cfg.write
  public Object getLabel()
  {
    return label;
  }
  
  public String getLabelString(CfgFunction cfgFunction)
  {
    if (cfgFunction == null || cfgFunction.fileName == null)
    {
      return (String)label;
    }
    else
    {
      if (label instanceof String)
      {
	return (String)label;
      }
      else
      {
	return cfgFunction.fileName + ":" + label;
      }
    }
  }

  public final void setSN(int sequenceNumber)
  {
    this.sequenceNumber = sequenceNumber;
  }

  public final int getSN()
  {
    return sequenceNumber;
  }

  /* How to use setDone(), getDone(), and initDone() to traverse a graph?
    pre-condition: for all nodes, node.getDone() == true
    (i.e. node.done == Ast.classDone)
    1. initDone()
    2. for EACH node, node.setDone()
    Note: each node must call setDone() exactly once.
    post-condition: for all nodes, node.getDone() == true
  */
  public final void setDone()
  {
    done = !done;
  }

  public final boolean getDone()
  {
    return done == classDone;
  }
  
  public static final void initDone()
  {
    classDone = !classDone;
  }
  
  static
  {
    classDone = false;
  }
  
  /**
   * Label of this node.  It may be
   * <ul>
   * <li> Integer</li>
   * <li> String: "filename:lineno", or 
   *      "address1:address2:...:addressn" resulting from CfgCompact </li>
   * </ul>
   */
  protected Object label;

  /**
   * Used in
   * <ul>
   * <li> Pda.read(): numbering each node uniquely when constructing a PDA
   * from the CFG </li>
   * <li> Cfg.defUse(): storing the defuse value </li>
   * </ul>
   */
  protected int sequenceNumber;

  /**
   * The address of this node in the CFG generated by rc.  This is kept
   * so as to allow for mapping from the compacted CFG to the original CFG
   */
  protected int address;

  protected boolean done;

  protected static boolean classDone;

  // fake multiple inheritance
  // begin interface ShortestPathNode
  protected final void ShortestPathNode(Vector inEdges, Vector outEdges)
  {
    NodeBase(inEdges, outEdges);
    PQElement();
    distance = -1;
    parent = null;
  }
  
  // begin interface NodeBase
  protected final void NodeBase(Vector inEdges, Vector outEdges)
  {
    if (inEdges != null)
      this.inEdges = inEdges;
    else
      this.inEdges = new Vector();

    if (outEdges != null)
      this.outEdges = outEdges;
    else
      this.outEdges = new Vector();
  }
  
  public final Vector getInEdges()
  {
    return inEdges;
  }

  public final Vector getOutEdges()
  {
    return outEdges;
  }

  protected Vector inEdges, outEdges;
  // end interface NodeBase

  // begin interface PQElement
  protected final void PQElement()
  {
    index = -1;
  }
  
  // begin interface Comparable
  public int compareTo(Object obj)
  {
    return compareTo(((ShortestPathNode)obj).getDistance());
  }
  // end interface Comparable

  public void setIndex(int index)
  {
    this.index = index;
  }

  public int getIndex()
  {
    return index;
  }
  
  int index;
  // end interface PQElement

  public final int getDistance()
  {
    return distance;
  }

  public final void setDistance(int distance)
  {
    this.distance = distance;
  }

  public final EdgeBase getParent()
  {
    return parent;
  }

  public final void setParent(EdgeBase parent)
  {
    this.parent = parent;
  }

  /**
   * Returns
   * -1: if this.distance is less than distance2
   * 0: if this.distance equals distance2
   * 1: if this.distance is greater than distance2
   */
  public int compareTo(int distance2)
  {
    if (distance >= 0 && distance2 >= 0)
    {
      if (distance < distance2)
	return -1;
      else if (distance > distance2)
	return 1;
      else
	return 0;
    }
    else if (distance >= 0)
      return -1;
    else if (distance2 >= 0)
      return 1;
    else
      return 0;
  }

  int distance;
  EdgeBase parent;
  // end interface ShortestPathNode
}
