// Generate fmtstr.fsa by: cpp -P fmtstr.fsa.cpp > fmtstr.fsa

state start "Start";
state unsafe "Error";

// TODO: gettext(cst), dgettext(any,cst), dcgettext(any,cst,any)
// See also the see also section of gettext(3), libintl.h

// TODO: Add MS *printf* functions, like
// _tprintf, _cprintf, _scprintf, _scwprintf, etc.
// See http://msdn.microsoft.com/library/default.asp?url=/library/en-us/vclib/html/_crt_format_specification_fields_.2d_.printf_and_wprintf_functions.asp
// See also RATS database

// False positive (rare?): printf(e ? "foo" : "bar");
// easily fixable; match for { conditional { any } { cst str } { cst str } }

#define NOTCSTSTR \
    { metanot { or \
        { string { string_cst { any } } { ellipsis } } \
        { function_call \
            { identifier "gettext" } \
            { string { string_cst { any } } { ellipsis } } \
        } \
        { function_call \
            { identifier "dgettext" } \
            { or \
                { cast { lexical_cst "0" } } \
                { string { string_cst { any } } { ellipsis } } \
            } \
            { string { string_cst { any } } { ellipsis } } \
            { ellipsis } \
        } \
        { function_call \
            { identifier "ngettext" } \
            { string { string_cst { any } } { ellipsis } } \
            { string { string_cst { any } } { ellipsis } } \
            { ellipsis } \
        } \
        { function_call \
            { identifier "dcgettext" } \
            { or \
                { cast { lexical_cst "0" } } \
                { string { string_cst { any } } { ellipsis } } \
            } \
            { string { string_cst { any } } { ellipsis } } \
            { or { identifier "__LC_MESSAGES" } { lexical_cst { any } } } \
            { ellipsis } \
        } \
        { function_call \
            { identifier "dngettext" } \
            { or \
                { cast { lexical_cst "0" } } \
                { string { string_cst { any } } { ellipsis } } \
            } \
            { string { string_cst { any } } { ellipsis } } \
            { string { string_cst { any } } { ellipsis } } \
            { any } \
        } \
        { function_call \
            { identifier "dcngettext" } \
            { or \
                { cast { lexical_cst "0" } } \
                { string { string_cst { any } } { ellipsis } } \
            } \
            { string { string_cst { any } } { ellipsis } } \
            { string { string_cst { any } } { ellipsis } } \
            { any } \
            { or { identifier "__LC_MESSAGES" } { lexical_cst { any } } } \
        } \
    } } \


ast err1 { function_call
    { or
        { identifier "printf" }
        { identifier "scanf" }
        { identifier "printk" }
        { identifier "setproctitle" }
        { identifier "wprintf" }
        { identifier "wscanf" }
        { identifier "warn" }
        { identifier "warnx" }
        { identifier "rl_message" }
        { identifier "comerr" }
        { identifier "errmsg" }
        { identifier "g_print" }
        { identifier "g_printf" }
        { identifier "g_printerr" }
        { identifier "g_strdup_printf" }
    }
    NOTCSTSTR
    { ellipsis }
};
ast err2 { function_call
	{ or
	    { identifier "fprintf" }
	    { identifier "fscanf" }
	    { identifier "sscanf" }
	    { identifier "sprintf" }
	    { identifier "wsprintf" }
	    { identifier "wsprintfA" }
	    { identifier "wsprintfW" }
	    { identifier "syslog" }
	    { identifier "argp_failure" }
	    { identifier "argp_error" }
	    { identifier "err" }
	    { identifier "errx" }
	    { identifier "asprintf" }
	    { identifier "dprintf" }
	    { identifier "obstack_printf" }
	    { identifier "fwprintf" }
	    { identifier "fwscanf" }
	    { identifier "swscanf" }
	    { identifier "swprintf" }
	    { identifier "httpPrintf" }
	    { identifier "commerrno" }
	    { identifier "errmsgno" }
	    { identifier "g_fprintf" }
	    { identifier "g_sprintf" }
	    { identifier "g_string_printf" }
	    { identifier "g_string_append_printf" }
	    { identifier "g_string_sprintf" }
	    { identifier "g_string_sprintfa" }
	    { identifier "g_scanner_error" }
	    { identifier "g_scanner_warn" }
    }
    { any }
    NOTCSTSTR
    { ellipsis }
};
ast err3 { function_call
	{ or
	    { identifier "snprintf" }
	    { identifier "error" }
	    { identifier "strfmon" }
	    { identifier "strftime" }
	    { identifier "strftime_l" }
	    { identifier "swprintf" }
	    { identifier "wcsftime" }
	    { identifier "wcsftime_l" }
	    { identifier "serrmsg" }
	    { identifier "g_log" }
	    { identifier "g_snprintf" }
	    { identifier "g_error_new" }
	}
    { any }
    { any }
    NOTCSTSTR
    { ellipsis }
};
ast err4 { function_call
	{ or
	    { identifier "error_at_line" }
	    { identifier "strfmon_l" }
	    { identifier "serrmsgno" }
	    { identifier "g_set_error" }
	}
    { any }
    { any }
    { any }
    NOTCSTSTR
    { ellipsis }
};

transition start    unsafe  err1;
transition start    unsafe  err2;
transition start    unsafe  err3;
transition start    unsafe  err4;
