// $Id: Cfg2Dot.java,v 1.12 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import java.util.*;
import gnu.getopt.*;

/**
 * User application to visualize CFG
 */
public class Cfg2Dot
{
  static final String optionString = "af:i:o:p" + Util.getOptionString(),
    optionUsage =
    "Usage: Cfg2Dot [options]\n" +
    "  -a\t\tWrite ASTs\n" +
    "  -f <name>\tWrite the function <name> (can have this option multiple times)\n" +
    "  -i <file>\tRead the input from <file>\n" +
    "  -o <file>\tWrite the output to <file>\n" +
    "  -p\t\tWrite addresses\n" +
    Util.getOptionUsage();
  
  public static void main(String args[]) throws IOException
  {
    Cfg cfg = new Cfg();
    String cfgFileName = "-", dotFileName = "-", name;
    boolean isWriteAst = false, isWriteAddress = false;
    Getopt opt;
    int ch;
    HashSet functionsToWrite = null;

    opt = new Getopt("Cfg2Dot", args, optionString, Util.getLongOpts());
    while ((ch = opt.getopt()) != -1)
    {
      switch(ch)
      {
	case 'a':
	  isWriteAst = true;
	  break;

	case 'f':
	  if (functionsToWrite == null)
	    functionsToWrite = new HashSet();
	  name = opt.getOptarg();
	  if (functionsToWrite.contains(name))
	    Util.warn(Util.WARNING, Util.FILE_FORMAT, "");
	  else
	    functionsToWrite.add(name);
	  break;
	  
	case 'i':
	  cfgFileName = opt.getOptarg();
	  break;
	  
	case 'o':
	  dotFileName = opt.getOptarg();
	  break;
	  
	case 'p':
	  isWriteAddress = true;
	  break;
	  
	default:
	  Util.processOption(ch, opt, optionUsage);
      }
    }
    if ((args.length - opt.getOptind()) != 0)
    {
      Util.stderr.println(optionUsage);
      System.exit(1);
    }
    cfg.read(cfgFileName, true);
    cfg.writeToDot(dotFileName, isWriteAst, isWriteAddress, functionsToWrite);
  }
}
