// $Id: TransitionEdge.java,v 1.3 2003/09/22 21:31:57 hchen Exp $

import java.io.*;
import java.util.*;

/**
 * Represent an Edge in the transition graph
 */
public class TransitionEdge implements EdgeBase
{
  public TransitionEdge()
  {
    this(null, null, null);
  }

  public TransitionEdge(Ast label, TransitionNode srcNode, TransitionNode dstNode)
  {
    EdgeBase(srcNode, dstNode);
    setLabel(label);
  }
  
  public final void setLabel(Ast label)
  {
    this.label = label;
  }

  public final Ast getLabel()
  {
    return label;
  }

  /**
   * Remove this edge from the edge lists of both its srcNode and
   * dstNode
   */
  public final void remove()
  {
    Vector edges;
    int i;

    edges = getSrcNode().getOutEdges();
    for (i = 0; i < edges.size(); i++)
      if ((TransitionEdge)edges.get(i) == this)
	break;
    if (i >= edges.size())
      Util.die(Util.INTERNAL, "Cannot find this edge in srcNode");
    edges.remove(i);

    edges = getDstNode().getInEdges();
    for (i = 0; i < edges.size(); i++)
      if ((TransitionEdge)edges.get(i) == this)
	break;
    if (i >= edges.size())
      Util.die(Util.INTERNAL, "Cannot find this edge in dstNode");
    edges.remove(i);
  }
  
  /**
   * The AST on this edge
   */
  protected Ast label;

  // fake multiple inheritance
  // begin interface EdgeBase
  protected final void EdgeBase(NodeBase srcNode, NodeBase dstNode)
  {
    if (srcNode != null && dstNode != null)
      setNodes(srcNode, dstNode);
  }
  
  public final void setSrcNode(NodeBase srcNode)
  {
    this.srcNode = srcNode;
  }

  public final void setDstNode(NodeBase dstNode)
  {
    this.dstNode = dstNode;
  }
  
  public final NodeBase getSrcNode()
  {
    return srcNode;
  }

  public final NodeBase getDstNode()
  {
    return dstNode;
  }

  public final void setNodes(NodeBase srcNode, NodeBase dstNode)
  {
    this.srcNode = srcNode;
    this.dstNode = dstNode;
    srcNode.getOutEdges().add(this);
    dstNode.getInEdges().add(this);
  }

  NodeBase srcNode, dstNode;
  // end interface EdgeBase
}
