/* ====Adjacency.H=============================================================================
 *
 * Author: Patrice Koehl, March 2020
 * Department of Computer Science
 * University of California, Davis
 *
 * Generates an adjacency table for all edges of a mesh
 * ============================================================================================ */

#ifndef _ADJACENCY2_H_
#define _ADJACENCY2_H_

/* ============================================================================================
   Includes
 * ============================================================================================ */

#include <tuple>

/* ============================================================================================
   The class
 * ============================================================================================ */

  class Adjacency2 {
	public:
		// constructs table
		void construct(Mesh& mesh, std::vector<std::tuple<int, int, double> >& ListPair);

		// returns unique index corresponding to entry (i, j)
		int getIndex(int i, int j);

		// returns table size
		int getSize() const;

	private:
		// members
		std::vector<std::set<int> > data;
		std::vector<int> iMap;
		int size;
  };

/* ============================================================================================
   Construct the adjacency table
 * ============================================================================================ */

  void Adjacency2::construct(Mesh& mesh, std::vector<std::tuple<int, int, double> >& ListPair)
  {
	int n = mesh.vertices.size();

	data.clear();
	iMap.clear();
	data.resize(n);
	iMap.resize(n);

	// build table
	for(EdgeIter e = mesh.edges.begin(); e != mesh.edges.end(); e++) {
		HalfEdgeIter h = e->he;
		int i = h->vertex->index;
		int j = h->flip->vertex->index;
		if (i > j) std::swap(i, j);
		data[i].insert(j);
	}

	// build iMap
	size = 0;
	for (int i = 0; i < n; i++) {
		iMap[i] = size;
		size += data[i].size();
		for (std::set<int>::iterator it = data[i].begin(); it != data[i].end(); it++) {
			int j = *it;
			ListPair.push_back(std::make_tuple(i, j, 0.));
		}
	}
  }

/* ============================================================================================
   Find index of a pair (i,j)
 * ============================================================================================ */

  int Adjacency2::getIndex(int i, int j)
  {
	if (i > j) std::swap(i, j);

	int k = 0;
	for (std::set<int>::iterator it = data[i].begin(); it != data[i].end(); it++) {
		if (*it == j) break;
		k++;
	}

	return iMap[i] + k;
}

/* ============================================================================================
   return size of adjacency table (should be equal to # of edges in mesh)
 * ============================================================================================ */

  int Adjacency2::getSize() const
  {
	return size;
  }

#endif
