/* ===============================================================================================
   OTMesh:  Computes the distance between two 3D meshes on OT distance

   Author:  Patrice Koehl
   Date:    3/25/2020
   Version: 1
   =============================================================================================== */

#ifndef _OTMESH_H_
#define _OTMESH_H_

/* ===============================================================================================
   System includes
   =============================================================================================== */

#include <iostream>
#include <iomanip>
#include <sstream>
#include <string>
#include <cstring>
#include <stdlib.h>
#include <fstream>
#include <cmath>
#include <ctime>
#include <unistd.h>
#include <cstdlib>
#include <limits>
#include <assert.h>
#include <pthread.h>

/*================================================================================================
 Definitions for multi-threading
================================================================================================== */

#define NUM_THREADS 32

int threadids[NUM_THREADS];
pthread_t threads[NUM_THREADS];

/* ===============================================================================================
   Local includes
   =============================================================================================== */

#include "ConjGradOT.h"
ConjGradOT conjgrad;

#include "ConjGradOT_m.h"
ConjGradOT_m conjgrad_m;

#include "MeshIO.h"
#include "Descriptors.h"
#include "Spectral.h"
#include "Align.h"
#include "OT1.h"
#include "OT1M.h"
#include "WriteRes.h"

 OT1 ot;
 OT1_OPTM otw;
 Descriptors descriptors;
 Spectral spectral;
 Align align;
 WriteRes write_res;

#include "Optim.h"
 Optim optim;

#include "MeshDist.h"

 MeshDist meshdist;

/* ===============================================================================================
   Prototypes
   =============================================================================================== */

static void usage(char** argv);
bool parse_args(int argc, char **argv, std::string *INFILE1, std::string *INFILE2, int *method,
	double *a1, double *a2, int *desc_type, int *flag_kpt, int *nkeep, int *flag_refine, std::string *OUTFILE);

#endif
