/* ====Adjacency.H=============================================================================
 *
 * Author: Patrice Koehl, March 2020
 * Department of Computer Science
 * University of California, Davis
 *
 * Generates an adjacency table for all edges of a mesh
 * ============================================================================================ */

#ifndef _ADJACENCY_H_
#define _ADJACENCY_H_

/* ============================================================================================
   Includes
 * ============================================================================================ */

/* ============================================================================================
   The class
 * ============================================================================================ */

  class Adjacency {
	public:
		// constructs table
		void construct(Mesh& mesh, std::vector<std::set<int> >& data);

		// returns unique index corresponding to entry (i, j)
		int getIndex(std::vector<std::set<int> >& data, int i, int j);

		// returns table size
		int getSize() const;

	private:
		// members
		std::vector<int> iMap;
		int size;
  };

/* ============================================================================================
   Construct the adjacency table
 * ============================================================================================ */

  void Adjacency::construct(Mesh& mesh, std::vector<std::set<int> >& data) 
  {
	int n = mesh.vertices.size();

	data.clear();
	iMap.clear();
	data.resize(n);
	iMap.resize(n);

	// build table
	for(EdgeIter e = mesh.edges.begin(); e != mesh.edges.end(); e++) {
		HalfEdgeIter h = e->he;
		int i = h->vertex->index;
		int j = h->flip->vertex->index;
		data[i].insert(j);
		data[j].insert(i);
	}

	// build iMap
	size = 0;
	for (int i = 0; i < n; i++) {
		iMap[i] = size;
		size += data[i].size();
	}
  }

/* ============================================================================================
   Find index of a pair (i,j)
 * ============================================================================================ */

  int Adjacency::getIndex(std::vector<std::set<int> >& data, int i, int j)
  {
	if (i > j) std::swap(i, j);

	int k = 0;
	for (std::set<int>::iterator it = data[i].begin(); it != data[i].end(); it++) {
		if (*it == j) break;
		k++;
	}

	return iMap[i] + k;
}

/* ============================================================================================
   return size of adjacency table (should be equal to # of edges in mesh)
 * ============================================================================================ */

  int Adjacency::getSize() const
  {
	return size;
  }

#endif
