#pragma once

#include "Types.h"

class Edge {
public:
	// constructor
	Edge();

	// one of the halfedges associated with this edge
	HalfEdgeIter he;

	// boolean flag to indicate if edge is on a generator
	bool onGenerator;

	// id between 0 and |E|-1
	int index;

	// edge length
	double length;

	// returns cotan weight associated with this edge
	double cotan() const;

	// checks if this edge is on the boundary
	bool onBoundary() const;
};

inline Edge::Edge():
onGenerator(false),
index(-1)
{

}

inline double Edge::cotan() const
{
	return 0.5*(he->cotan() + he->flip->cotan());
}

inline bool Edge::onBoundary() const
{
	return he->onBoundary || he->flip->onBoundary;
}
