/*=================================================================================
  ReadPDB.h
  Version 1: 9/30/2019

  Purpose: reads in a PDB file and stores coordinates of (sub) sets of atoms

================================================================================================== */

#ifndef _READPDB_H_
#define _READPDB_H_

#include <stdio.h>
#include "Atoms.h"

/* ===============================================================================================
   Read from PDB file for each atom selected:
	- coordinates x,y, and z
	- whole line (stored for printing)
	- compute mass
   =============================================================================================== */

void readPDB(std::string fileName, int flag, int flag_mass, std::vector<Atoms>& atoms, int *nchains, double *center)
{
	std::string line;

  	std::ifstream inFile;
	inFile.open(fileName.c_str());

	char letter;
	double x,y,z,o,b;
	double M = 1.0;
	std::string coord, coord2;
	int natom = 0;
	int nres = -1;
	int nchain = -1;
	int ires = -1;
	int iresc;
	int iread = 0;
	std::string curr_res="     ";
	std::string curr_chain="x";
	std::string res, chain;
	int i0, i1, i2, i3, i4, i5;
	while (getline(inFile, line)) // until reach the end of file 
	{
//		if (line.substr(0,6) == "HETATM") break;
		if (line.substr(0,6) == "ATOM  ") // only read lines with ATOM at position 0
		{
			iread = 1;
			res = line.substr(21,5);
			iresc = std::stoi(line.substr(22,4));
			chain = line.substr(21,1);
			if(chain != curr_chain || std::abs(iresc-ires)>1) {
				nchain++;
				curr_chain = chain;
			}
			if(res != curr_res) {
				nres++;
				curr_res = res;
				ires = iresc;
			}
			if(flag == 1) {
				if(line[12]==' ') {
					letter = line[13];
				}
				else {
					letter=line[12];
				}
				coord = line.substr(30,24);
				sscanf(coord.c_str(),"%8lf%8lf%8lf",&x,&y,&z);
				b = 0;
				if(line.length() >= 59) {
					coord2 = line.substr(54,6);
					sscanf(coord2.c_str(),"%6lf",&o);
					coord2 = line.substr(60,6);
					sscanf(coord2.c_str(),"%6lf",&b);
				}
				Atoms at;
				at.setLine(line.substr(0,60));
				at.setXYZ(x,y,z);
				at.setBfact(b);
				at.setResId(nres);
				at.setChainId(nchain);
				if(flag_mass == 0) {
					at.setUniMass(M);
				} else {
					at.setMass(letter);
				}
				atoms.push_back(at);
				natom++;
			}
			else {
				if(line.find("CA")!= std::string::npos) {
					letter=line[13];
					coord = line.substr(30,24);
					sscanf(coord.c_str(),"%8lf%8lf%8lf",&x,&y,&z);
					b = 0;
					if(line.length() >= 59) {
						coord2 = line.substr(54,6);
						sscanf(coord2.c_str(),"%6lf",&o);
						coord2 = line.substr(60,6);
						sscanf(coord2.c_str(),"%6lf",&b);
					}
					Atoms at;
					at.setLine(line.substr(0,60));
					at.setXYZ(x,y,z);
					if(flag_mass == 0) {
						at.setUniMass(M);
					} else {
						at.setMass(letter);
					}
					at.setBfact(b);
					at.setResId(nres);
					at.setChainId(nchain);
					atoms.push_back(at);
					natom++;
				}
			}
		} else if (line.substr(0,6) == "ANISOU") // only read lines with ATOM at position 0
		{
			if(iread == 1) {
				if(flag == 1) {
					coord2 = line.substr(28,42);
					sscanf(coord2.c_str(),"%7d%7d%7d%7d%7d%7d",&i0, &i1, &i2, &i3, &i4, &i5);
					atoms[natom-1].U[0] = i0/10000.;
					atoms[natom-1].U[1] = i1/10000.;
					atoms[natom-1].U[2] = i2/10000.;
					atoms[natom-1].U[3] = i3/10000.;
					atoms[natom-1].U[4] = i4/10000.;
					atoms[natom-1].U[5] = i5/10000.;
				} else {
					if(line.find("CA")!= std::string::npos) {
						coord2 = line.substr(28,42);
						sscanf(coord2.c_str(),"%7d%7d%7d%7d%7d%7d",&i0, &i1, &i2, &i3, &i4, &i5);
						atoms[natom-1].U[0] = i0/10000.;
						atoms[natom-1].U[1] = i1/10000.;
						atoms[natom-1].U[2] = i2/10000.;
						atoms[natom-1].U[3] = i3/10000.;
						atoms[natom-1].U[4] = i4/10000.;
						atoms[natom-1].U[5] = i5/10000.;
					}
				}
				iread = 0;
			}
		}

	}
	*nchains = nchain+1;

	center[0] = 0; center[1] = 0; center[2] = 0;
	for(int i = 0; i < natom; i++)
	{
		for(int k = 0; k < 3; k++) center[k] += atoms[i].coord[k];
	}
	center[0] /= natom; center[1] /= natom; center[2] /= natom;
	for(int i = 0; i < natom; i++)
	{
		for(int k = 0; k < 3; k++) atoms[i].coord[k] -= center[k];
	}

	inFile.close();

}

/* ===============================================================================================
   Read RNA from PDB file for each atom selected:
	- coordinates x,y, and z
	- whole line (stored for printing)
	- compute mass
   =============================================================================================== */

void readRNA(std::string fileName, int flag, int flag_mass, std::vector<Atoms>& atoms, int *nchains)
{
	std::string line;

  	std::ifstream inFile;
	inFile.open(fileName.c_str());

	char letter;
	double x,y,z,o,b;
	double M = 1.0;
	std::string coord, coord2;
	int natom = 0;
	int nres = -1;
	int nchain = -1;
	int ires = -1;
	int iresc;
	int iread = 0;
	std::string curr_res="     ";
	std::string curr_chain="x";
	std::string res, chain;
	int i0, i1, i2, i3, i4, i5;
	while (getline(inFile, line)) // until reach the end of file 
	{
//		if (line.substr(0,6) == "HETATM") break;
		if (line.substr(0,6) == "ATOM  " && (line.substr(16,1)==" " || line.substr(16,1)=="A")) // only read lines with ATOM at position 0
		{
			iread = 1;
			res = line.substr(21,5);
			iresc = std::stoi(line.substr(22,4));
			chain = line.substr(21,1);
			if(chain != curr_chain || std::abs(iresc-ires)>1) {
				nchain++;
				curr_chain = chain;
			}
			if(res != curr_res) {
				nres++;
				curr_res = res;
				ires = iresc;
			}
			if(flag == 1) {
				if(line[12]==' ') {
					letter = line[13];
				}
				else {
					letter=line[12];
				}
				coord = line.substr(30,24);
				sscanf(coord.c_str(),"%8lf%8lf%8lf",&x,&y,&z);
				b = 0;
				if(line.length() >= 59) {
					coord2 = line.substr(54,6);
					sscanf(coord2.c_str(),"%6lf",&o);
					coord2 = line.substr(60,6);
					sscanf(coord2.c_str(),"%6lf",&b);
				}
				Atoms at;
				at.setLine(line.substr(0,60));
				at.setXYZ(x,y,z);
				at.setBfact(b);
				at.setResId(nres);
				at.setChainId(nchain);
				if(flag_mass == 0) {
					at.setUniMass(M);
				} else {
					at.setMass(letter);
				}
				atoms.push_back(at);
				natom++;
			}
			else if(flag==0) {
				if(line.substr(13,1)== "P" || line.substr(13,3)== "C4'"  ||
				   (line.substr(13,2)== "C8" && (line.substr(19,1)== "A" || line.substr(19,1)== "G")) ||
				   (line.substr(13,2)== "C6" && (line.substr(19,1)== "U" || line.substr(19,1)== "C" || line.substr(19,1)=="T"))) {
					letter=line[13];
					coord = line.substr(30,24);
					sscanf(coord.c_str(),"%8lf%8lf%8lf",&x,&y,&z);
					b = 0;
					if(line.length() >= 59) {
						coord2 = line.substr(54,6);
						sscanf(coord2.c_str(),"%6lf",&o);
						coord2 = line.substr(60,6);
						sscanf(coord2.c_str(),"%6lf",&b);
					}
					Atoms at;
					at.setLine(line.substr(0,60));
					at.setXYZ(x,y,z);
					if(flag_mass == 0) {
						at.setUniMass(M);
					} else {
						at.setMass(letter);
					}
					at.setBfact(b);
					at.setResId(nres);
					at.setChainId(nchain);
					atoms.push_back(at);
					natom++;
				}
			}
			else if(flag==2) {
				if(line.substr(13,1)== "P") {
					letter=line[13];
					coord = line.substr(30,24);
					sscanf(coord.c_str(),"%8lf%8lf%8lf",&x,&y,&z);
					b = 0;
					if(line.length() >= 59) {
						coord2 = line.substr(54,6);
						sscanf(coord2.c_str(),"%6lf",&o);
						coord2 = line.substr(60,6);
						sscanf(coord2.c_str(),"%6lf",&b);
					}
					Atoms at;
					at.setLine(line.substr(0,60));
					at.setXYZ(x,y,z);
					if(flag_mass == 0) {
						at.setUniMass(M);
					} else {
						at.setMass(letter);
					}
					at.setBfact(b);
					at.setResId(nres);
					at.setChainId(nchain);
					atoms.push_back(at);
					natom++;
				}
			}
		} else if (line.substr(0,6) == "ANISOU") // only read lines with ATOM at position 0
		{
			if(iread == 1) {
				if(flag == 1) {
					coord2 = line.substr(28,42);
					sscanf(coord2.c_str(),"%7d%7d%7d%7d%7d%7d",&i0, &i1, &i2, &i3, &i4, &i5);
					atoms[natom-1].U[0] = i0/10000.;
					atoms[natom-1].U[1] = i1/10000.;
					atoms[natom-1].U[2] = i2/10000.;
					atoms[natom-1].U[3] = i3/10000.;
					atoms[natom-1].U[4] = i4/10000.;
					atoms[natom-1].U[5] = i5/10000.;
				} else {
					if(line.find("CA")!= std::string::npos) {
						coord2 = line.substr(28,42);
						sscanf(coord2.c_str(),"%7d%7d%7d%7d%7d%7d",&i0, &i1, &i2, &i3, &i4, &i5);
						atoms[natom-1].U[0] = i0/10000.;
						atoms[natom-1].U[1] = i1/10000.;
						atoms[natom-1].U[2] = i2/10000.;
						atoms[natom-1].U[3] = i3/10000.;
						atoms[natom-1].U[4] = i4/10000.;
						atoms[natom-1].U[5] = i5/10000.;
					}
				}
				iread = 0;
			}
		}

	}
	*nchains = nchain+1;

	inFile.close();

}

#endif
