#ifndef _PYMOL_H_
#define _PYMOL_H_

/*================================================================================================
  Pymol.h
  Version 1: 6/29/2020

Copyright (c) Patrice Koehl.

  Generate pymol scripts to display network
================================================================================================== */

  class PYMOL {

	public:

		void write_network(std::string filename, std::vector<Atoms>& atoms, double *center,
		std::vector<Links>& pairs, int flag_ave, int flag_weight, int idx);

  };

/*================================================================================================
  Generate pymol scripts to display network
================================================================================================== */

  void PYMOL::write_network(std::string filename, std::vector<Atoms>& atoms, double *center,
		std::vector<Links>& pairs, int flag_ave, int flag_weight, int idx)
  {

	std::ofstream output;
	output.open(filename);

	/*========================================================================================
  	Generate pymol headers
	========================================================================================== */

	output << "python" << std::endl;
	output << "from pymol.cgo import *" << std::endl;
	output << "from pymol import cmd" << std::endl;
	output << " " << std::endl;

	/*========================================================================================
  	Generate vertices
	========================================================================================== */

	int natoms = atoms.size();
	int nlinks = pairs.size();

	bool *flag_atm = new bool[natoms];
	for(int i = 0; i < natoms; i++) flag_atm[i] = false;

	int i1, j1;
	for(int i = 0; i < nlinks; i++) {

		i1 = pairs[i].atm1;
		j1 = pairs[i].atm2;
		flag_atm[i1] = true;
		flag_atm[j1] = true;
	}

	output << " " <<std::endl;
	output << "vertices = [" << std::endl;
	output << " " <<std::endl;
	output << "	COLOR, 0.0, 0.0, 1.0," << std::endl;
	output << " " <<std::endl;

	double rad = 0.5;

	for(int i = 0; i < natoms; i++) {

		if(flag_atm[i]) {
			output << "	SPHERE, " << atoms[i].coord[0]+center[0] << ", " << atoms[i].coord[1]+center[1]<< ", " << atoms[i].coord[2] + center[2];
			output << ", " << rad << "," << std::endl;
		}
	}

	delete [] flag_atm;

//	output << "	END" << std::endl;
	output << "]" << std::endl;
	output << " " <<std::endl;

	/*========================================================================================
  	Generate edges
	========================================================================================== */

	output << " " <<std::endl;
	output << "edges = [" << std::endl;
	output << " " <<std::endl;
	output << "	BEGIN, LINES," << std::endl;
	output << "	COLOR, 0.4, 0.4, 0.4," << std::endl;
	output << " " <<std::endl;

	if(flag_weight==0) {

		output << " " <<std::endl;

		for(int i = 0; i < nlinks; i++) 
		{
			output << "	LINEWIDTH, 1," << std::endl;
			i1 = pairs[i].atm1;
			j1 = pairs[i].atm2;
			output << "	VERTEX, " << atoms[i1].coord[0] + center[0] << ", " << atoms[i1].coord[1] + center[1] << ", " << atoms[i1].coord[2] +center[2] << "," << std::endl;
			output << "	VERTEX, " << atoms[j1].coord[0] + center[0] << ", " << atoms[j1].coord[1] + center[1] << ", " << atoms[j1].coord[2] +center[2] << "," << std::endl;
			output << " " <<std::endl;
		}

	} else {

		std::vector<double> kvals;
		double kval;
		for(int i = 0; i < nlinks; i++) 
		{
			i1 = pairs[i].atm1;
			j1 = pairs[i].atm2;
			if(flag_ave==2) {
				kval = std::sqrt( atoms[i1].kconst * atoms[j1].kconst);
			} else {
				kval = (atoms[i1].kconst + atoms[j1].kconst)/2.0;
			}
			kvals.push_back(kval);
		}

		int nval = kvals.size();
		std::sort(kvals.begin(), kvals.end());
		double kmax;
		kmax = kvals[nval-1];
		std::cout << "kmax = " << kmax << std::endl;

		double wmax = 15.0;

		for(int i = 0; i < nlinks; i++) 
		{
			i1 = pairs[i].atm1;
			j1 = pairs[i].atm2;
			if(flag_ave==2) {
				kval = std::sqrt( atoms[i1].kconst * atoms[j1].kconst);
			} else {
				kval = (atoms[i1].kconst + atoms[j1].kconst)/2.0;
			}
			kval = kval*wmax/kmax;
//			if(kval>0.02) {
				output << "	LINEWIDTH, " << kval << "," << std::endl;
				output << "	VERTEX, " << atoms[i1].coord[0] + center[0] << ", " << atoms[i1].coord[1] + center[1] << ", " << atoms[i1].coord[2] + center[2] << "," << std::endl;
				output << "	VERTEX, " << atoms[j1].coord[0] +center[0] << ", " << atoms[j1].coord[1] + center[1] << ", " << atoms[j1].coord[2] +center[2] << "," << std::endl;
				output << " " <<std::endl;
//			}
		}
	}

	output << " " <<std::endl;
	output << "	END" << std::endl;
	output << "]" << std::endl;
	output << " " <<std::endl;

	/*========================================================================================
  	End file
	========================================================================================== */

	std::string v = "\'vertices" + std::to_string(idx) + "\')";
	std::string e = "\'edges" + std::to_string(idx) + "\')";
	output << " " <<std::endl;
	output << "cmd.load_cgo(vertices,"+v  << std::endl;
	output << "cmd.load_cgo(edges,"+e << std::endl;
	output << " " <<std::endl;
	output << "python end" << std::endl;
	output << " " <<std::endl;

	output.close();

  }

#endif

	
