/* ========================================================================================
   Definitions for multithreading
   ======================================================================================== */

typedef struct derivs_ki_data {
        int N1;
        int N2;
	int flag_ave;
	double facb;
	int nmode1;
	int nmode2;
	double lambda;
	double lambda_ent;
        double *eigVect;
        double *eigVal;
        double *bfact;
        std::vector<Atoms> atoms;
        std::vector<Links> pairs;
        double *Uij;
        double *X;
        double *Work;
        double *G;
} derivs_ki_data;

derivs_ki_data derivs_ki[NUM_THREADS];

/* ========================================================================================
   Computes derivative of energy on one thread
   ======================================================================================== */

  void* deriv_ki_thread(void* data)
  {
	int threadid = *((int *) data);

	int natoms = derivs_ki[threadid].atoms.size();
	int npairs = derivs_ki[threadid].pairs.size();
	int npar = 3*natoms;
	int N1 = derivs_ki[threadid].N1;
	int N2 = derivs_ki[threadid].N2;
	double *dDiagHm1 = derivs_ki[threadid].Work;
	double *eigVect = derivs_ki[threadid].eigVect;
	double *eigVal = derivs_ki[threadid].eigVal;
	double *Uij = derivs_ki[threadid].Uij;


	int iat, jat;
	double a, b, sum;
	int inc=1;
	double *u, *e1, *e2;
	double facti, factj, ki, kj, kij;

	for(int k = N1; k < N2; k++) {
		memset(dDiagHm1, 0, npar*sizeof(double));
		u = &Uij[3*k];
		iat = derivs_ki[threadid].pairs[k].atm1;
		jat = derivs_ki[threadid].pairs[k].atm2;
		kij = derivs_ki[threadid].pairs[k].kconst;
		ki  = derivs_ki[threadid].X[iat];
		kj  = derivs_ki[threadid].X[jat];

		facti = 0.5; factj = 0.5;
		if(derivs_ki[threadid].flag_ave==2) {
			facti = 0.5*kj/kij;
			factj = 0.5*ki/kij;
		}

		for(int i = derivs_ki[threadid].nmode1; i < derivs_ki[threadid].nmode2; i++) {
			e1 = &eigVect[i*npar + 3*iat];
			e2 = &eigVect[i*npar + 3*jat];
			a = u[0]*(e1[0]-e2[0]) + u[1]*(e1[1]-e2[1]) + u[2]*(e1[2]-e2[2]);
			a = a/eigVal[i];
			daxpy_(&npar, &a, &eigVect[i*npar], &inc, dDiagHm1, &inc);
		}

		for(int i = 0; i < npar; i++) {
			a = dDiagHm1[i];
			dDiagHm1[i] = -a *a;
		}

		sum = 0.;
		for(int i = 0; i < natoms; i++)
		{
			a = derivs_ki[threadid].bfact[i] - derivs_ki[threadid].atoms[i].bfact;
			b = derivs_ki[threadid].facb*(dDiagHm1[3*i] + dDiagHm1[3*i+1] + dDiagHm1[3*i+2]);
			sum += a*b;
		}
		sum *= derivs_ki[threadid].lambda;
		derivs_ki[threadid].G[iat] += 2*facti*sum;
		derivs_ki[threadid].G[jat] += 2*factj*sum;

		sum = 0.;
		for(int i = derivs_ki[threadid].nmode1; i < derivs_ki[threadid].nmode2; i++) {
			e1 = &eigVect[i*npar + 3*iat];
			e2 = &eigVect[i*npar + 3*jat];
			a = u[0]*(e1[0]-e2[0]) + u[1]*(e1[1]-e2[1]) + u[2]*(e1[2]-e2[2]);
			a = (a*a)/eigVal[i];
			sum += a;
		}
		sum *= derivs_ki[threadid].lambda_ent;
		derivs_ki[threadid].G[iat] += facti*sum;
		derivs_ki[threadid].G[jat] += factj*sum;
	}
	return 0;
  }
