/*================================================================================================

  NormalModes: Fit B factors
  Version 1: 09/28/2019

Copyright (c) Patrice Koehl.

================================================================================================== */

#ifndef _FITMODES_H_
#define _FITMODES_H_

/*================================================================================================
  Global includes
================================================================================================== */

  #include <iostream>
  #include <iomanip>
  #include <fstream>
  #include <string>
  #include <math.h>
  #include <cstdlib>
  #include <unistd.h>
  #include <vector>
  #include <algorithm>

/*================================================================================================
 Definitions for multi-threading
================================================================================================== */

  #include "Atoms.h"
  #include "Links.h"

#define NUM_THREADS 32
pthread_t threads[NUM_THREADS];
int threadids[NUM_THREADS];

typedef struct hessian_data {
	int Nvect;
	int N1;
	int N2;
	int Nat1;
	int Nat2;
	int Ncoord;
	int Npair;
	std::vector<Links> ListPair;
	double *Uij;
	double *U1ij;
	double *Uijk;
	double *Uijkl;
	double *Vect1;
	double *Vect2;
	double *Vect3;
} hessian_data;

hessian_data hessians[NUM_THREADS];

typedef struct grid_data {
	int firstcell;
	int lastcell;
	int Nx;
	int Ny;
	double cutoff2;
	int mindiff;
	int *Cells;
	int *ListCell;
	int *Head;
	std::vector<Atoms> atoms;
	std::vector <Links> Contacts;
} grid_data;

grid_data grids[NUM_THREADS];

/*================================================================================================
  Local includes
================================================================================================== */

  #include "ReadPDB.h"
  #include "Network.h"
  #include "HessianGo.h"

  Network net;
  HessianGo hess;

  #include "Tools.h"
  #include "OptimBfact_ki.h"
  #include "WriteResults.h"
  #include "delcx.h"
  #include "pymol.h"

  DELCX delcx;

  WriteResults wres;
  Tools tools;

  PYMOL pml;

/*================================================================================================
  Prototypes
================================================================================================== */

  static void usage(char** argv);
  void parse_args(int argc, char** argv, std::string *inputfile, std::string *outputfile, 
	std::string *targetfile, int *rna, int *atoms, int *flag_network, int *flag_potential, 
	double *cutoff, int *flag_mass, int *nmodes, int *flag_optim, int *flag_rigid, int *flag_mean, 
	int *flag_ent);

#endif
