/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.jrCommunicationException;
import edu.ucdavis.jr.jrx.AtomicPrintlnPrintStream;
import edu.ucdavis.jr.jrx.JRX;
import edu.ucdavis.jr.jrx.ProxyInputStream;
import edu.ucdavis.jr.jrx.ProxyOutputStream;
import edu.ucdavis.jr.jrx.Semaphore;
import edu.ucdavis.jr.jrx.TerminationData;
import edu.ucdavis.jr.jrx.VM;
import edu.ucdavis.jr.jrx.jrBoolean;
import edu.ucdavis.jr.jrx.jrByte;
import edu.ucdavis.jr.jrx.jrChar;
import edu.ucdavis.jr.jrx.jrDouble;
import edu.ucdavis.jr.jrx.jrFloat;
import edu.ucdavis.jr.jrx.jrInt;
import edu.ucdavis.jr.jrx.jrLong;
import edu.ucdavis.jr.jrx.jrShort;
import edu.ucdavis.jr.jrx.jrvm_intf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class jrvm
extends UnicastRemoteObject
implements jrvm_intf {
    static final long serialVersionUID = 0L;
    private String name;
    public static String vmName;
    public String host;
    public static JRX jrx;
    public static jrvm thisVM;
    private static Hashtable<UnicastRemoteObject, UnicastRemoteObject> remTable;
    private Thread pChecker;
    private Thread reaper;
    private Object dieMutex;
    private boolean dying = false;
    private static Semaphore termination;
    public static boolean implicitTermination;
    private static int verbosity;
    private static final int NUMARGS = 8;
    private static final int SERVER_ARG = 0;
    private static final int NAME_ARG = 1;
    private static final int LOCAL_ARG = 2;
    private static final int PORT_ARG = 3;
    private static final int IMPLICIT_ARG = 4;
    private static final int VERBOSITY_ARG = 5;
    private static final int IDLE_ARG = 6;
    private static final int VMTYPE_ARG = 7;
    private static final String LOCAL_HOST = "localhost";
    private static long timestamp;
    private static final long time_inc = 1L;
    private boolean pinged = true;
    private int missed = 0;
    private static long ready;
    private static long messages;
    private static boolean amIdle;

    protected jrvm(String string, String string2) throws RemoteException {
        this.name = string;
        this.host = string2;
        this.dieMutex = new Object();
        this.pChecker = new PingChecker();
        this.pChecker.start();
        this.reaper = new Reaper();
        this.reaper.start();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyVM() throws RemoteException {
        Object object = this.dieMutex;
        synchronized (object) {
            this.dying = true;
            this.dieMutex.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void die() {
        try {
            boolean bl = true;
            Enumeration<UnicastRemoteObject> enumeration = remTable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    bl &= UnicastRemoteObject.unexportObject(enumeration.nextElement(), true);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            try {
                bl &= UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        finally {
            System.exit(0);
        }
    }

    public static Object createInstance(jrvm_intf jrvm_intf2, String string, Class[] classArray, Object[] objectArray) {
        try {
            return jrvm_intf2.innerCreateInstance(string, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    @Override
    public Object innerCreateInstance(String string, Class[] classArray, Object[] objectArray) throws RemoteException {
        Object obj;
        Class<?> clazz;
        if (classArray != null && objectArray != null) {
            jrvm.convertTypes(classArray);
        }
        try {
            clazz = jrvm.class.getClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.threadBirth();
            obj = constructor.newInstance(objectArray);
            this.threadDeath();
        }
        catch (Exception exception) {
            this.threadDeath();
            exception.printStackTrace();
            throw new RemoteException(exception.toString());
        }
        try {
            Method method = clazz.getMethod("JRgetjrresref", new Class[0]);
            Object object = method.invoke(obj, new Object[0]);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object createInstance(jrvm_intf jrvm_intf2, String string, Class[] classArray, Object[] objectArray, String string2) {
        try {
            return jrvm_intf2.innerCreateInstance(string, classArray, objectArray, string2);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    @Override
    public Object innerCreateInstance(String string, Class[] classArray, Object[] objectArray, String string2) throws RemoteException {
        Object obj;
        Class<?> clazz;
        if (classArray != null && objectArray != null) {
            jrvm.convertTypes(classArray);
        }
        try {
            clazz = jrvm.class.getClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.threadBirth();
            obj = constructor.newInstance(objectArray);
            this.threadDeath();
        }
        catch (Exception exception) {
            this.threadDeath();
            exception.printStackTrace();
            throw new RemoteException(exception.toString());
        }
        try {
            clazz = jrvm.class.getClassLoader().loadClass(string2);
            obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void startmain(String[] stringArray) throws Exception {
        Class[] classArray = new Class[]{stringArray.getClass()};
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        amIdle = false;
        jrvm.threadBirth();
        Class<?> clazz = jrvm.class.getClassLoader().loadClass(stringArray[0]);
        Method method = clazz.getMethod("main", classArray);
        if (method == null) {
            throw new NoSuchMethodError("main");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodError("main not static");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new NoSuchMethodError("main not public");
        }
        Object[] objectArray = new Object[]{stringArray2};
        method.invoke(null, objectArray);
        jrvm.threadDeath();
    }

    private static Class[] convertTypes(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].equals(jrBoolean.class)) {
                classArray[i] = Boolean.TYPE;
                continue;
            }
            if (classArray[i].equals(jrChar.class)) {
                classArray[i] = Character.TYPE;
                continue;
            }
            if (classArray[i].equals(jrByte.class)) {
                classArray[i] = Byte.TYPE;
                continue;
            }
            if (classArray[i].equals(jrShort.class)) {
                classArray[i] = Short.TYPE;
                continue;
            }
            if (classArray[i].equals(jrInt.class)) {
                classArray[i] = Integer.TYPE;
                continue;
            }
            if (classArray[i].equals(jrLong.class)) {
                classArray[i] = Long.TYPE;
                continue;
            }
            if (classArray[i].equals(jrFloat.class)) {
                classArray[i] = Float.TYPE;
                continue;
            }
            if (!classArray[i].equals(jrDouble.class)) continue;
            classArray[i] = Double.TYPE;
        }
        return classArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 8) {
            System.exit(1);
        }
        try {
            String[] stringArray2;
            VM vM;
            jrvm jrvm2;
            JRX jRX;
            implicitTermination = Integer.parseInt(stringArray[4]) == 1;
            verbosity = Integer.parseInt(stringArray[5]);
            String string = stringArray[1];
            String string2 = stringArray[0].equals(stringArray[2]) ? LOCAL_HOST : stringArray[0];
            String string3 = "//" + string2 + ":" + stringArray[3] + "/JRX";
            System.setProperty("java.rmi.server.hostname", stringArray[2]);
            jrx = jRX = (JRX)Naming.lookup(string3);
            System.setIn(new ProxyInputStream(jRX.getStdIn()));
            System.setOut(new AtomicPrintlnPrintStream(new ProxyOutputStream(jRX.getStdOut())));
            System.setErr(new AtomicPrintlnPrintStream(new ProxyOutputStream(jRX.getStdErr())));
            vmName = string;
            if (stringArray[7].equals("VM")) {
                jrvm2 = new jrvm(string, stringArray[2]);
                vM = new VM(stringArray[1], jrvm2);
            } else {
                stringArray2 = Class.forName(stringArray[7]);
                Constructor<?> constructor = stringArray2.getConstructor(jrvm.convertTypes(jRX.getParamTypes(stringArray[1])));
                jrvm2 = (jrvm)constructor.newInstance(jRX.getParamValues(stringArray[1]));
                vM = jrvm.createVMProxy(stringArray[7], stringArray[1], jrvm2);
            }
            thisVM = jrvm2;
            jRX.hello(stringArray[1], vM, Integer.parseInt(stringArray[6]) == 1);
            if (stringArray.length > 8) {
                stringArray2 = new String[stringArray.length - 8];
                System.arraycopy(stringArray, 8, stringArray2, 0, stringArray2.length);
                jrvm.startmain(stringArray2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("jrvm exception: " + invocationTargetException.getTargetException().getMessage());
            invocationTargetException.getTargetException().printStackTrace();
            try {
                jrx.exit(1);
            }
            catch (Exception exception) {
                System.err.println("Abnormal exit!");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("jrvm exception: " + exception.getMessage());
            exception.printStackTrace();
            try {
                jrx.exit(1);
            }
            catch (Exception exception2) {
                System.err.println("Abnormal exit!");
                exception2.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static VM createVMProxy(String string, String string2, jrvm_intf jrvm_intf2) {
        try {
            Class<?> clazz = Class.forName("JR" + string);
            Constructor<?> constructor = clazz.getConstructor(String.class, jrvm_intf.class);
            return (VM)constructor.newInstance(string2, jrvm_intf2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static void registerRemote(UnicastRemoteObject unicastRemoteObject) {
        remTable.put(unicastRemoteObject, unicastRemoteObject);
    }

    public static void unregisterRemote(UnicastRemoteObject unicastRemoteObject) {
        remTable.remove(unicastRemoteObject);
    }

    public void unregisterAllRemote() {
        Enumeration<UnicastRemoteObject> enumeration = remTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                UnicastRemoteObject.unexportObject(enumeration.nextElement(), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized long getTimestamp() {
        return ++timestamp;
    }

    public static synchronized long setTimestamp(long l) {
        if (l + 1L > ++timestamp) {
            timestamp = l + 1L;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ping() throws RemoteException {
        jrvm jrvm2 = this;
        synchronized (jrvm2) {
            this.pinged = true;
            this.missed = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPing() {
        boolean bl = false;
        jrvm jrvm2 = this;
        synchronized (jrvm2) {
            bl = this.pinged;
            this.pinged = false;
        }
        if (!bl) {
            ++this.missed;
        }
        try {
            jrx.ping();
            this.missed = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.missed > 2) {
            System.err.println("Abnormal exit -- heartbeat failed!");
            System.exit(1);
        }
    }

    public static final void threadBirth() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        jrvm.threadBirth_internal();
        termination.release();
    }

    private static final void threadBirth_internal() {
        ++ready;
        jrvm.notifyNotIdle();
    }

    public static final void threadDeath() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        jrvm.threadDeath_internal();
        termination.release();
    }

    private static final void threadDeath_internal() {
        --ready;
        jrvm.notifyIdle();
    }

    private static final void messageSent() {
        ++messages;
    }

    private static final void messageReceived() {
        --messages;
    }

    public static final void sendAndDie() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        jrvm.messageSent();
        jrvm.threadDeath_internal();
        termination.release();
    }

    public static final void ariseAndReceive() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        jrvm.messageReceived();
        jrvm.threadBirth_internal();
        termination.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void notifyNotIdle() {
        amIdle = false;
        if (amIdle && ready == 1L) {
            try {
                termination.release();
                try {
                    jrx.notIdle(vmName);
                }
                finally {
                    termination.acquire();
                }
            }
            catch (Exception exception) {
                System.err.println("notifyNotIdle cannot reach JRX ... exiting!");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void notifyIdle() {
        if (ready == 0L) {
            amIdle = true;
            try {
                termination.release();
                try {
                    jrx.idle(vmName);
                }
                finally {
                    termination.acquire();
                }
            }
            catch (Exception exception) {
                System.err.println("notifyIdle cannot reach JRX ... exiting!");
                System.exit(1);
            }
        }
    }

    @Override
    public final TerminationData checkIdle() throws RemoteException {
        return jrvm.checkLocalIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final TerminationData checkLocalIdle() {
        termination.acquire();
        try {
            TerminationData terminationData = new TerminationData(amIdle, messages);
            return terminationData;
        }
        finally {
            termination.release();
        }
    }

    public static VM createVM(String string, String string2) {
        try {
            return jrx.createVM(string, string2);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    public static VM createVM(VM vM, String string) {
        try {
            return jrx.createVM(vM, string);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    public static VM createVM(String string, String string2, String string3, Class[] classArray, Object[] objectArray) {
        try {
            return jrx.createVM(string, string2, string3, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    public static VM createVM(VM vM, String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            return jrx.createVM(vM, string, string2, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    static {
        remTable = new Hashtable();
        termination = new Semaphore(1);
        implicitTermination = false;
        verbosity = 0;
        timestamp = 0L;
        ready = 0L;
        messages = 0L;
        amIdle = true;
    }

    private class Reaper
    extends Thread {
        final int SLEEP_TIME = 50;

        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = jrvm.this.dieMutex;
            synchronized (object) {
                while (!jrvm.this.dying) {
                    try {
                        jrvm.this.dieMutex.wait();
                    }
                    catch (Exception exception) {}
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jrvm.this.die();
            }
        }
    }

    private class PingChecker
    extends Thread {
        final int SLEEP_TIME = 5000;

        private PingChecker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jrvm.this.dying) break;
                jrvm.this.checkPing();
            }
        }
    }
}

