/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.jrx.InLock;
import edu.ucdavis.jr.jrx.LockId;
import edu.ucdavis.jr.jrx.Sorter;
import java.rmi.RemoteException;

class CLock {
    InLock theLock;
    private LockId lockId;
    public boolean duplicate = false;
    public boolean isRemoteLock;
    public long numDupes = 0L;
    private static DupSorter dupSorter = new DupSorter();

    public CLock(InLock inLock) throws RemoteException {
        this.theLock = inLock;
        this.lockId = inLock.getLockId();
        this.isRemoteLock = this.lockId.site.compareTo("jrx") == 0;
    }

    public static void markDuplicates(CLock[] cLockArray) throws RemoteException {
        int n = 0;
        Sorter.sort(cLockArray, dupSorter);
        if (cLockArray.length > 0) {
            LockId lockId = cLockArray[0].lockId;
            for (int i = 1; i < cLockArray.length; ++i) {
                if (lockId.site.compareTo(cLockArray[i].lockId.site) == 0 && lockId.num == cLockArray[i].lockId.num) {
                    cLockArray[i].duplicate = true;
                    ++cLockArray[n].numDupes;
                    continue;
                }
                n = i;
                lockId = cLockArray[n].lockId;
            }
        }
    }

    public void lock() throws RemoteException {
        this.theLock.lock();
    }

    public void unlock() throws RemoteException {
        this.theLock.unlock();
    }

    public void waitOnLock() throws RemoteException {
        this.theLock.waitOnLock();
    }

    public void lockEC() throws RemoteException {
        this.theLock.lockEC();
    }

    public void unlockEC() throws RemoteException {
        this.theLock.unlockEC();
    }

    public void forwardTo(InLock inLock) throws RemoteException {
        this.theLock.forwardTo(inLock);
        this.lockId = this.getLock().getLockId();
    }

    public InLock getLock() throws RemoteException {
        return this.theLock.getInnerLock();
    }

    public final LockId getLockId() throws RemoteException {
        return this.theLock.getLockId();
    }

    public boolean isDupeOf(CLock cLock) throws RemoteException {
        return this.lockId.site.compareTo(cLock.lockId.site) == 0 && this.lockId.num == cLock.lockId.num;
    }

    static class DupSorter
    extends Sorter.SortCompare {
        DupSorter() {
        }

        @Override
        public boolean precede(Object object, Object object2) {
            LockId lockId = ((CLock)object).lockId;
            LockId lockId2 = ((CLock)object2).lockId;
            int n = lockId.site.compareTo(lockId2.site);
            if (n < 0) {
                return true;
            }
            if (n == 0) {
                return lockId.num < lockId2.num;
            }
            return false;
        }
    }
}

