/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.parser;

import edu.ucdavis.jr.trans.sun.tools.javac.parser.Tokens;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Log;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Name;

public class Keywords {
    protected static final Context.Key<Keywords> keywordsKey = new Context.Key();
    private final Log log;
    private final Name.Table names;
    private final Tokens[] key;
    private int maxKey = 0;
    private Name[] tokenName = new Name[Tokens.values().length];

    public static Keywords instance(Context context) {
        Keywords keywords = context.get(keywordsKey);
        if (keywords == null) {
            keywords = new Keywords(context);
        }
        return keywords;
    }

    private Keywords(Context context) {
        context.put(keywordsKey, this);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        for (Tokens tokens : Tokens.values()) {
            if (tokens.name != null) {
                this.enterKeyword(tokens.name, tokens);
                continue;
            }
            this.tokenName[tokens.ordinal()] = null;
        }
        this.key = new Tokens[this.maxKey + 1];
        for (int i = 0; i <= this.maxKey; ++i) {
            this.key[i] = Tokens.IDENTIFIER;
        }
        for (Tokens tokens : Tokens.values()) {
            if (tokens.name == null) continue;
            this.key[this.tokenName[tokens.ordinal()].index] = tokens;
        }
    }

    public Tokens key(Name name) {
        return name.index > this.maxKey ? Tokens.IDENTIFIER : this.key[name.index];
    }

    public String token2string(Tokens tokens) {
        switch (tokens) {
            case IDENTIFIER: {
                return Log.getLocalizedString("token.identifier", new Object[0]);
            }
            case CHARLITERAL: {
                return Log.getLocalizedString("token.character", new Object[0]);
            }
            case STRINGLITERAL: {
                return Log.getLocalizedString("token.string", new Object[0]);
            }
            case INTLITERAL: {
                return Log.getLocalizedString("token.integer", new Object[0]);
            }
            case LONGLITERAL: {
                return Log.getLocalizedString("token.long-integer", new Object[0]);
            }
            case FLOATLITERAL: {
                return Log.getLocalizedString("token.float", new Object[0]);
            }
            case DOUBLELITERAL: {
                return Log.getLocalizedString("token.double", new Object[0]);
            }
            case ERROR: {
                return Log.getLocalizedString("token.bad-symbol", new Object[0]);
            }
            case EOF: {
                return Log.getLocalizedString("token.end-of-input", new Object[0]);
            }
            case DOT: 
            case COMMA: 
            case SEMI: 
            case LPAREN: 
            case RPAREN: 
            case LBRACKET: 
            case RBRACKET: 
            case LBRACE: 
            case RBRACE: {
                return "'" + tokens.name + "'";
            }
        }
        return tokens.name;
    }

    private void enterKeyword(String string, Tokens tokens) {
        Name name;
        this.tokenName[tokens.ordinal()] = name = this.names.fromString(string);
        if (name.index > this.maxKey) {
            this.maxKey = name.index;
        }
    }
}

