% ABLEpack example 1
% 
% standard non-Hermitian problem, find eigenvalues only

% ppp input
% ---------

% set ppp required input parameters
% ---------------------------------

problem = 1;        % standard non-Hermitian eigenvalue problem
matbal = 0;         % don't do matrix balancing preprocessing

A = sprandn( 10, 10, .2 );  % sparse random matrix
B = sparse(eye( 10 ));

neig = 5;           % want 5 eigenvalues, at least

% optional parameters
% -------------------
% setting them here to get level 1 of the algorithm (instead of default 2)
% because 1 just finds eigenvalues
%
% parameters with non-default values are marked NONDEFAULT

nb = 1;            % regular Lanczos, not block
maxit = 100;       % max 100 iterations

precond = 0;       % no preconditioning
alpha = 0;         % shift and invert won't be used, so 0

L = 0;             % LU factorization not computed
U = 0;

% NONDEFAULT (following four)
fulldual = 0;      % level 1, eigenvalues only
semidual = 0;
group    = 0;
treatbd  = 0;



% call ppp
% --------

[ neig, ritz, eigvecl, eigvecr, resl, resr, condnum ] ...
 = ppp(problem,...                     % REQUIRED
       matbal,...                      % matbal only required for problem 1
       A,B,...                         % A REQUIRED for problem 1, A/B for 2
       neig,...                        % REQUIRED
       fulldual,semidual,group,treatbd,...
       nb,maxit,...
       precond,...
       alpha,L,U...
      );


% print eigenvalues (approximate)
% -------------------------------

fprintf( 'approximate eigenvalues\n' );
display( ritz );

