% ABLEpack example 3
% 
% generalized non-Hermitian problem, find eigentriplets

% ppp input
% ---------

% set ppp required input parameters
% ---------------------------------

problem = 2;        % generalized non-Hermitian eigenvalue problem
matbal = 0;         % don't do matrix balancing preprocessing

A = sparse( [ 1 1 0 0 0 0 0 0 0 0; ...
              1 2 1 0 0 0 0 0 0 0; ...
              0 1 3 1 0 0 0 0 0 0; ...
              0 0 1 4 1 0 0 0 0 0; ...
              0 0 0 1 5 1 0 0 0 0; ...
              0 0 0 0 1 6 1 0 0 0; ...
              0 0 0 0 0 1 7 1 0 0; ...
              0 0 0 0 0 0 1 8 1 0; ...
              0 0 0 0 0 0 0 1 9 1; ...
              0 0 0 0 0 0 0 0 1 10; ] );

B = sparse( [10 0 0 0 0 3 0 0 0 0; ...
              0 9 0 0 0 0 3 0 0 0; ...
              0 0 8 0 0 0 0 3 0 0; ...
              0 0 0 7 0 0 0 0 3 0; ...
              0 0 0 0 6 0 0 0 0 3; ...
              3 0 0 0 0 5 0 0 0 0; ...
              0 3 0 0 0 0 4 0 0 0; ...
              0 0 3 0 0 0 0 3 0 0; ...
              0 0 0 3 0 0 0 0 2 0; ...
              0 0 0 0 3 0 0 0 0 1; ] );

%A = sprandn( 10, 10, .2 );  % sparse random matrix
%B = sprandn( 10, 10, .2 );  % sparse random matrix

neig = 2;           % want 2 eigenvalues, at least

% optional parameters
% -------------------

fulldual = 0;
semidual = 1;
group    = 1;
treatbd  = 1;

nb = 1;
maxit = 100;

precond = 1;
alpha = 1;
L = 0;
U = 0;


% call ppp
% --------

[ neig, ritz, eigvecl, eigvecr, resl, resr, condnum, ...
 ritzvalue, szoft, duality, exdual, omega, resl_e, resr_e, tolconv,numlsteps]...
 = ppp(problem,...                     % REQUIRED
       matbal,...                      % matbal only required for problem 1
       A,B,...                         % A REQUIRED for problem 1, A/B for 2
       neig,...                        % REQUIRED
       fulldual, semidual, group, treatbd, ...
       nb, maxit, ...
       precond, ...
       alpha, L, U ...
      );

% printout script creates plots
% -----------------------------

printout;

