% ABLEpack example 2
% 
% standard non-Hermitian problem, find eigentriplets

% ppp input
% ---------

% set ppp required input parameters
% ---------------------------------

problem = 1;        % standard non-Hermitian eigenvalue problem
matbal = 0;         % don't do matrix balancing preprocessing

A = sprandn( 10, 10, .2 );  % sparse random matrix
B = sparse(eye( 10 ));

neig = 5;           % want 5 eigenvalues, at least

% optional parameters
% -------------------
% We don't need to set these, we'll just use the default values.


% call ppp
% --------

[ neig, ritz, eigvecl, eigvecr, resl, resr, condnum ] ...
 = ppp(problem,...                     % REQUIRED
       matbal,...                      % matbal only required for problem 1
       A,B,...                         % A REQUIRED for problem 1, A/B for 2
       neig...                         % REQUIRED
      );


% print eigentriplets (approximate)
% ---------------------------------

fprintf( 'approximate eigenvalues\n' );
display( ritz );

fprintf( 'approximate eigenvectors\n' );

fprintf( 'LEFT\n' );
display( eigvecl );

fprintf( 'RIGHT\n' );
display( eigvecr );

