program Test_Wrap3

  use DQMC_WRAPPER1
  implicit none

  ! This program tests the module of wrapper functions.
  
  type(wrapper1)     :: wrap1
  character(len=30)  :: fname
  integer, parameter :: fno = 30
  integer, parameter :: n = 4, L = 12
  logical            :: lex
  real               :: t1, t2

  !================!
  ! Initialization !
  !================!
  call cpu_time(t1)
  
  ! read in HSF
  inquire(file='HSF.dat', exist=lex)	
  if (lex) then
    open(unit=fno, file='HSF.dat', action='READ') 
  end if

  ! read in other parameters
  call DQMC_Wrap1_ReadBoth(wrap1, n, L, fname)
  if (lex) close(fno)

  !================!
  !     Compute    !
  !================!
  call DQMC_Wrap1_Compute(wrap1)

  !================!
  ! Output results !
  !================!
  !! output HSF
  open(unit=fno, file='HSF.dat', status="REPLACE", action='WRITE') 
  call DQMC_wrap1_OutputHSF(wrap1, fno)
  close(fno)

  !! Output parameters and time dependent measurements
  lex = CFG_Get(wrap1%cfg, PARAM_FNAME, fname)
  open(unit=fno, file=trim(fname)//".basic.out", &
       status="REPLACE", action='WRITE') 
  
  write(fno,*) "Version tw3"
  call DQMC_Hub_Print(wrap1%Hub, fno)
  !! print out time
  call cpu_time(t2)
  write(fno,*) "Running time:",  t2-t1, "(second)"
  close(fno)

  !! Output time dependent measurements
  open(unit=fno, file=trim(fname)//".tdm.out", &
       status="REPLACE", action='WRITE') 
  call DQMC_TDM_Print(wrap1%Tm, fno)
  close(fno)
  
  ! the extra output
  call Output_files
  
  ! Clean up
  call DQMC_Wrap1_Free(wrap1)

contains

  ! -----------------------------------------------------------------------

  subroutine Output_Files
    !
    ! This subroutine outputs results to files
    !

    ! ... Variables ...
    
    real(wp), pointer  :: avg(:,:), err(:,:), x(:), y(:)
    integer            :: m, n, nlines, i, j

    ! ... Parameters ...
    character(*), parameter :: FMT_G_CMPX = "(4(f20.16),3(i5))"
    character(*), parameter :: FMT_G_REAL = "(2(f20.16),3(i5))"
    character(*), parameter :: FMT_G_FUN  = "(2(f20.16),2(i5))"
    integer, parameter :: FID1= 21
    character(*), parameter :: stat = "REPLACE"
    
    ! ... Executable ...

    x => wrap1%Hub%S%cord(:,1)
    y => wrap1%Hub%S%cord(:,2)

    ! ==================================================
    ! Basic and pair measurements
    ! ==================================================
    open(unit=FID1,file=trim(fname)//'_BASIC.dat',status=stat,action='WRITE') 
    write(FID1,"(a30)") "# Equal_time_scalar_measurements:"
    call DQMC_Wrap1_Get(wrap1, EQ_UP_SPIN, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_UP_SPIN"
    call DQMC_Wrap1_Get(wrap1, EQ_DN_SPIN, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_DN_SPIN"
    call DQMC_Wrap1_Get(wrap1, EQ_P_ENERGY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_ENERGY (Potential)"
    call DQMC_Wrap1_Get(wrap1, EQ_K_ENERGY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_K_ENERGY (Kinetic)"
    call DQMC_Wrap1_Get(wrap1, EQ_ENERGY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_ENERGY   (Total)"
    call DQMC_Wrap1_Get(wrap1, EQ_DENSITY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_DENSITY"
    call DQMC_Wrap1_Get(wrap1, EQ_XX_FERR, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_XX_FERR"
    call DQMC_Wrap1_Get(wrap1, EQ_ZZ_FERR, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_ZZ_FERR"
    call DQMC_Wrap1_Get(wrap1, EQ_XX_AFER, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_XX_AFER"
    call DQMC_Wrap1_Get(wrap1, EQ_ZZ_AFER, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_ZZ_AFER"

    write(FID1,"(a30)") "# Equal_time_pair_measurements:"
    call DQMC_Wrap1_Get(wrap1, EQ_P_S, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_S"
    call DQMC_Wrap1_Get(wrap1, EQ_P_SX, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_SX"
    call DQMC_Wrap1_Get(wrap1, EQ_P_D, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_D"
    call DQMC_Wrap1_Get(wrap1, EQ_P_SXX, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_SXX"
    call DQMC_Wrap1_Get(wrap1, EQ_P_DXX, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_DXX"
    call DQMC_Wrap1_Get(wrap1, EQ_P_PX, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_PX"
    call DQMC_Wrap1_Get(wrap1, EQ_P_PY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_PY"
    call DQMC_Wrap1_Get(wrap1, EQ_P_PXY, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_PXY"
    call DQMC_Wrap1_Get(wrap1, EQ_P_PYX, m, n, avg, err)
    write(FID1,*) avg(1,1), err(1,1), "   =EQ_P_PYX"
    write(FID1,"(a)") '#EOF#'
    close(FID1)

    ! ==================================================
    ! Basic measurements: function values
    ! ==================================================

    call DQMC_Wrap1_Get(wrap1, EQ_G_FUN, m, n, avg, err)
    open(unit=FID1,file=trim(fname)//'_EQ_FUN.dat',status=stat,action='WRITE')
    write(FID1,"(a30)") "# Equal time Green's function G: "
    write(FID1,*)  m
    do i = 1, m
       write(FID1,FMT_G_FUN) avg(i,1), err(i,1), int(x(i)), int(y(i))
    enddo

    call DQMC_Wrap1_Get(wrap1, EQ_D_UPUP, m, n, avg, err)
    write(FID1,"(a30)") "# Density-density correlation fn: (up-up)"
    write(FID1,*)  m
    do i = 1, m
       write(FID1,FMT_G_FUN) avg(i,1), err(i,1), int(x(i)), int(y(i))
    enddo

    call DQMC_Wrap1_Get(wrap1, EQ_D_UPDN, m, n, avg, err)
    write(FID1,"(a30)") "# Density-density correlation fn: (up-dn)"
    write(FID1,*)  m
    do i = 1, m
       write(FID1,FMT_G_FUN) avg(i,1), err(i,1), int(x(i)), int(y(i))
    enddo

    call DQMC_Wrap1_Get(wrap1, EQ_XX_SPIN, m, n, avg, err)
    write(FID1,"(a30)") "# XX Spin correlation function"
    write(FID1,*)  m
    do i = 1, m
       write(FID1,FMT_G_FUN) avg(i,1), err(i,1), int(x(i)), int(y(i))
    enddo

    call DQMC_Wrap1_Get(wrap1, EQ_ZZ_SPIN, m, n, avg, err)
    write(FID1,"(a30)") "# ZZ Spin correlation function"
    write(FID1,*)  m
    do i = 1, m
       write(FID1,FMT_G_FUN) avg(i,1), err(i,1), int(x(i)), int(y(i))
    enddo
    write(FID1,"(a30)") '#EOF#'
    close(FID1)  

    ! ==================================================
    ! Time dependent measurements
    ! ==================================================
    call DQMC_Wrap1_Get(wrap1, UNEQ_G_QW, m, n, avg, err)

    ! write out G_QW
    open(unit=FID1,file=trim(fname)//'_UNEQ_G_QW.dat', &
         status=stat,action='WRITE')
    write(FID1,"(a)") '# G(k,w)='
    write(FID1,"(a30)") '# Re,Im(G), Re,Im(Error), l(w), n(kx), n(ky):'
    nlines = m*n/2
    write(FID1,*)  nlines
    do i = 1, m
       do j = 1, n/2	
          write(FID1,FMT_G_CMPX) avg(i,j), avg(i,j+n/2), &
               err(i,j), err(i,j+n/2), j-1, int(x(i)), int(y(i))
       enddo
    enddo
    write(FID1,"(a)") '#EOF#'
    close(FID1)

    ! write out G_QL
    call DQMC_Wrap1_Get(wrap1, UNEQ_G_QL, m, n, avg, err)
    open(unit=FID1, file=trim(fname)//'_UNEQ_G_QL.dat', &
         status=stat,action='WRITE')
    write(FID1,"(a)") '# G(k,T)='
    write(FID1,"(a30)") '# (Real) G, Error, (int) l(w), n(kx), n(ky):'
    nlines = m*n
    write(FID1,*)  nlines
    do i = 1, m
       do j = 1, n	
          write(FID1,FMT_G_REAL) avg(i,j), err(i,j), j-1, int(x(i)), int(y(i))
       enddo
    enddo
    write(FID1,"(a)") '#EOF#'
    close(FID1)

    ! write out G_NW
    call DQMC_Wrap1_Get(wrap1, UNEQ_G_NW, m, n, avg, err)
    open(unit=FID1, file=trim(fname)//'_UNEQ_G_NW.dat', &
         status=stat,action='WRITE')
    write(FID1,"(a)") '# G(k,w)='
    write(FID1,"(a30)") '# Re,Im(G), Re,Im(Error), l(w), n(kx), n(ky):'
    nlines = m*n/2
    write(FID1,*)  nlines
    do i = 1, m
       do j = 1, n/2	
          write(FID1,FMT_G_CMPX) avg(i,j), avg(i,j+n/2), &
               err(i,j), err(i,j+n/2), j-1, &
               int(x(i)), int(y(i))
       enddo
    enddo
    write(FID1,"(a)") '#EOF#'
    close(FID1)

    ! write out G_NL
    call DQMC_Wrap1_Get(wrap1, UNEQ_G_NL, m, n, avg, err)
    open(unit=FID1, file=trim(fname)//'_UNEQ_G_NL.dat', &
         status=stat,action='WRITE')
    write(FID1,"(a)") '# G(k,T)='
    write(FID1,"(a30)") '# (Real) G, Error, (int) l(w), n(kx), n(ky):'
    nlines = m*n
    write(FID1,*)  nlines
    do i = 1, m
       do j = 1, n	
          write(FID1,FMT_G_REAL) avg(i,j), err(i,j), j-1, int(x(i)), int(y(i))
       enddo
    enddo
    write(FID1,"(a)") '#EOF#'
    close(FID1)

  end subroutine Output_Files


end program Test_Wrap3

