program test7

  ! This program test the dqmc_simqmc module.

  use dqmc_simqmc
  implicit none

  ! parameters
  integer, parameter  :: L  = 14
  integer, parameter  :: Nc = 1
  integer, parameter  :: Na = 3
  integer, parameter  :: n  = Nc*(Na+1)
  integer, parameter  :: nL = n*L
  integer, parameter  :: nWarm = 200
  integer, parameter  :: nPass = 200
  real(wp), parameter :: U = 6.0D0
  real(wp), parameter :: dtau = 0.25D0
  integer, parameter  :: seed = 33553    ! if seed=0, system seed will 
                                         ! be randomly generated

  ! variables
  type(simqmc) :: qmc
  real(wp)     :: K(n,n), sup, sdn, val, diff_up, diff_dn
  real(wp), pointer  :: Gup(:,:), Gdn(:,:)
  real(wp)     :: Gup1(n*L,n*L), Gdn1(n*L,n*L)
  integer      :: i, j, row, col, ri, ci
  real         :: t1, t2, t3

  ! executables

  ! read K from Kmatrix.dat
  open(unit=10, file="KmatrixNc1.dat")
  read(10,*) 
  do i = 1,n
     do j =1,n
        read(10, *) row, col, val
        K(row, col) = val
     end do
  end do
  close(10)

  ! initialize qmc simulator
  call DQMC_QMC_Init(qmc, Nc, Na, L, U, dtau, K, nwarm, npass, seed, .true.)

  call cpu_time(t1)

  ! Warmup sweep    
  do i = 1, qmc%Hub%nWarm
     ! The second parameter means no measurement should be made.
     call DQMC_Hub_Sweep(qmc%Hub, NO_MEAS0)
     call DQMC_Hub_Sweep2(qmc%Hub, qmc%Hub%nTry)
  end do

  ! Loop here
  ! measurement sweep    
  do i = 1, qmc%Hub%nPass
     ! The second parameter means no measurement should be made.
     call DQMC_Hub_Sweep(qmc%Hub, NO_MEAS0)
     call DQMC_Hub_Sweep2(qmc%Hub, qmc%Hub%nTry)
  end do


  ! Get Green's function
  call cpu_time(t2)
  call DQMC_measure(qmc, Gup1, Gdn1, sup, sdn)
  call cpu_time(t3)
  print *, "time: ", t2-t1, t3-t2

  call DQMC_QMC_Free(qmc)

end program test7
