program dqmc_test
  ! This program checks the execution time for
  ! QUEST on a 2-dimensional PEriodic Reactangular
  ! Lattice (2DPERL)

  use DQMC_Cfg
  use DQMC_Geom_Wrap
  use DQMC_Hubbard
  implicit none

  real                :: t1, t2
  type(Config)        :: cfg
  type(Hubbard)       :: Hub
  type(GeomWrap)      :: Gwrap
  character(len=slen) :: gfile
  logical             :: valid, tformat
  integer             :: ns, avg, err, OPT

  call cpu_time(t1)  
  OPT=6
  
  ! Read input file
  call DQMC_Read_Config(cfg, STDIN)
   
  ! Initialize geometry
  call CFG_Get(cfg, "gfile", gfile)
  call DQMC_Geom_Read_Def(Hub%S, gfile, tformat)
  if(.not.tformat)then
   call DQMC_Geom_Fill(Gwrap,gfile)
   call DQMC_Geom_Init_AntiPBC(Gwrap,Hub%S,cfg)
  endif
  
  ! Initialize the rest data
  call DQMC_Hub_Config(Hub, cfg)

  ! Execution MC loop
  call DQMC_Hub_Run(Hub)

  call DQMC_Phy0_Resample(Hub%P0)
  call DQMC_Phy0_PrintStat(Hub%P0, Hub%S, OPT)

  ! Fourier transform of "phy0" (static) properties
  call DQMC_Fill_FourierC(Gwrap)
  call DQMC_Phy0_Get_and_Print_FT(Hub%P0,Gwrap,OPT)

  if(Hub%P2%compute)then

   avg=Hub%P2%avg

   call DQMC_Phy2_Resample(Hub%P2)
   !diagonalize Pairing matrix 
   call DQMC_Phy2_GetW(Hub%S, Hub%P2)
   !Analyze symmetry of pairing modes
   ns = Gwrap%SymmOp%nsymm
   call DQMC_Phy2_WaveSymm(Hub%S,Hub%P2%M3(:,avg),Gwrap%SymmOp%map_symm_p,ns)
                          
   !call DQMC_Phy2_WaveSymm(Hub%S%W,Hub%S%nwave,Hub%S%N_b,Hub%P2%M3(1:Hub%S%nwave,Hub%P2%avg),Gwrap%SymmOp%map_symm_b,ns,Hub%S%wrepr, &
   !                        Hub%S%wclass, Hub%S%wlabel, Hub%S%nwclass, Hub%S%nirrep)
   call dqmc_phy2_PrintSymm(Hub%S, Hub%P2, OPT)
  endif
  
  ! Clean up the used storage
  call DQMC_Hub_Free(Hub)
  call DQMC_Config_Free(cfg)
  
  call cpu_time(t2)
  write(STDOUT,*) "Running time:",  t2-t1, "(second)"

end program dqmc_test
