function [K, M] = defpencil(n, eigval, beta, mu )
%
% create defective symmetric pencil (K,M) of order n with eigvals eigval.
% Each eigval corresponds to a 2 by 2 Jordan block; hence
% n should be even, and the length of eigval, beta, and mu should be n/2.
%
% M is the direct sum of  [  0      beta(j) ]
%                         [ beta(j)  mu(j)  ]
%
% K is the direct sum of  
%  [         0                         eigval(j)*beta(j)       ]
%  [ eigval(j)*beta(j)  -eigval(j)^2*beta(j) + eigval(j)*mu(j) ]
%
n = 2*round((n-1)/2);
evens = [2:2:n];
odds = [1:2:n-1];
d = zeros(n,1);
d(evens) = eigval(1:n/2);
f = zeros(n-1,1);
f(odds) = beta(1:n/2);
M = diag(d) + diag(f,1) + diag(f,-1);
d = zeros(n,1);
d(evens) = -eigval(1:n/2).*eigval(1:n/2) + mu(1:n/2).*eigval(1:n/2);
f = zeros(n-1,1);
f(odds) = beta(1:n/2).*eigval(1:n/2);
K = diag(d) + diag(f,1) + diag(f,-1);
