function [probtype,n,m,sigma,MustPreprocess,AltForm,aeig,A,B,K,C,M] =...
    getmat(testprob)
%
% GETMAT - Get test matrices
%
%------------------------------------
n=0;
m=0;
MustPreprocess = 0;
AltForm=0;
A = 0;
B = 0;
C = 0;
K = 0;
M = 0;
if (testprob == 1)
   n = 40;
   A = randn(n);
   A = A + A.';
   B = eye(n);
   B(1,1) = -1;
   aeig = eig(B\A);
   probtype = 'linear   ';
   sigma  = 1.0;                %-------Shift value.
   MustPreprocess = 0;
elseif (testprob == 2)
%
%--------The file speaker107 contains three matrices: K,C,M of order 107.
%
%        Quadratic problem  K*x + (lam)*C*x + (lam)^2*M*x = 0.
%
%        File speaker107eig contains the 214 eigenvalues computed by the
%        QZ algorithm using the LAPACK driver DGEGV.  
%
%        MSC.NASTRAN designation: s4899asym.
%
   AltForm = 0;
   clear K C M;
   load speaker107;
   load speaker107eig;
   m = size(K,1);
   knorm = norm(K,1);
   n = 2*m;
   probtype = 'quadratic';
%   sigma  = 1.5e3*i;            %-------Shift value.
   sigma  = 2.5e3*i;            %-------Shift value.
%   sigma = 100;
   MustPreprocess = 0;
elseif (testprob == 3)
   AltForm = 0;
   m = 50;
   n = 2*m;
   K = randn(m);
   K = K + K.';
   C = eye(m);
   C(1,1) = -1;
   M = eye(m);
   O = zeros(m);
%   sf = 1.e8;
   sf = 1.e-4;
   K = K*sf; M = M*sf; C=C*sf;
   if (AltForm)
      A = [ O K;...
            K C];
      B = [ K  O;...
            O -M];
   else
      A = [-K O;...
            O M];
      B = [ C M;...
            M O];
   end
   aeig = eig(B\A);
   probtype = 'quadratic';
%   probtype = 'linear   ';
   sigma  = 1.0;                %-------Shift value.
   MustPreprocess = 0;
elseif (testprob == 4)
%
%--------The file shaft400 contains three matrices: K,C,M of order 400.
%
%        Quadratic problem  K*x + (lam)*C*x + (lam)^2*M*x = 0.
%
%        File speaker400eig contains the 398 ``finite'' eigenvalues computed 
%        by the QZ algorithm using the LAPACK driver DGEGV.  For this problem,
%        ``finite'' was taken to be any eigenvalue whose magnitude was less 
%        than 1.e15.
%        The matrix M is diagonal with 201 diagonal entries which are zero.
%        The matrix C has only one nonzero entry.
%
%        MSC/NASTRAN designation: y6103e.
%
   AltForm = 0;
   clear K C M;
   load shaft400;
   load shaft400eig;
   m = size(K,1);
   n = 2*m;
   probtype = 'quadratic';
   sigma  = 1.0e2*i;            %-------Shift value.
   MustPreprocess = 1;          %-------Should preprocess due to singular B.
elseif (testprob == 5)
%
%--------The file speaker334 contains three matrices: K,C,M of order 334.
%
%        Quadratic problem  K*x + (lam)*C*x + (lam)^2*M*x = 0.
%
%        File speaker334eig contains the eigenvalues computed 
%        by the QZ algorithm using the LAPACK driver DGEGV.  
%
%        MSC/NASTRAN designation: aabslg1sym.
%
   AltForm = 0;
   clear K C M;
   load speaker334;
   load speaker334eig;
   sf = sqrt(norm(K,1));
   K = K/sf;
   M = sf*M;
   aeig=aeig/sf;
   m = size(K,1);
   n = 2*m;
   probtype = 'quadratic';
   sigma  = 2.0e3*i;            %-------Shift value.
   sigma = sigma/sf;
   MustPreprocess = 0;          %-------No preprocessing required.
elseif (testprob == 6)
%
%--------The routine defpencil generates a defective symmetric pencil
%        of order n with prescribed eigenvalues.
%
   m = 100;
%   aeig = [1:m];
   aeig = (1/2).^([1:m]/4);
   n = 2*m;
   [A, B] = defpencil( n, aeig, ones(size(aeig)), aeig );
   probtype = 'linear   ';
%   sigma  = 0.0;                %-------Shift value.
   sigma  = 1.0;                %-------Shift value.
%   sigma  = 0.7;                %-------Shift value.
   MustPreprocess = 0;          %-------No preprocessing required.
   Bhat = B;
elseif (testprob == 7)
%   n = 320;
%   n=120;
   n = 100;
   m = 10;
%   m = 9;
%   m = 8;
   A = diag((1/2).^([1:n]/4));
%   A(n,n)=-A(n,n);
   A(1,1)=-A(1,1);
%   A = diag((1/2).^([1:n]/16));
%   A = diag([1:n]);
   B = diag(real(exp(pi*i*[1:n])));
   aeig = diag(B*A);
   B(1:m,1:m) = eye(m);
   Bhat = B;
   B(1:m,1:m) = zeros(m);
%   V = randn(n);
   V = orth(randn(n));
   A = V*A*V';
   B = V*B*V';
   Bhat = V*Bhat*V';
   probtype = 'linear   ';
   sigma  = 0.078;               %-------Shift value.
   MustPreprocess = 1;          %-------(No) preprocessing required.
elseif (testprob == 8)
   n = 100;
   A = diag([1:n]);
   B = diag(real(exp(pi*i*[1:n])));
   aeig = diag(B*A);
   Bhat = B;
   V = orth(randn(n));
   A = V*A*V';
   B = V*B*V';
   Bhat = V*Bhat*V';
   probtype = 'linear   ';
   sigma  = 0.08;               %-------Shift value.
   MustPreprocess = 1;          %-------(No) preprocessing required.
elseif (testprob == 9)
   m = 80;
   n=2*m;
%   shaft80M;
   shaft80Msing;
   shaft80K;
   shaft80C;
   shaft80eig;
   AltForm = 1;
   O = zeros(m);
   if (AltForm)
      A = [ O K;...
            K C];
      B = [ K  O;...
            O -M];
   else
      A = [-K O;...
            O M];
      B = [ C M;...
            M O];
   end
   probtype = 'quadratic';
%   sigma  = 100.0;               %-------Shift value.
   sigma  = 1.e5*i;               %-------Shift value.
   MustPreprocess = 1;          %-------(No) preprocessing required.
   tstvec = ones(n,1);
   tstvec(20) = 0;
   tstvec(m+1:n) = (diag(M)==0); %--------tstvec is a vector in the null space 
elseif (testprob == 10)
%
%--------The file speaker538 contains three matrices: K,C,M of order 538.
%
%        Quadratic problem  K*x + (lam)*C*x + (lam)^2*M*x = 0.
%
%        Mass matrix is singular with rank 334.
%        File speaker538eig contains the eigenvalues computed 
%        by the QZ algorithm using the LAPACK driver DGEGV.  
%
%        MSC/NASTRAN designation: s4899sym
%
   AltForm = 1;
   clear K C M;
   load speaker538;
   load speaker538eig;
   m = size(K,1);
   n = 2*m;
   probtype = 'quadratic';
   sigma  = 2.0e3*i;            %-------Shift value.
   MustPreprocess = 1;          %-------Preprocessing required.
else
   error( 'Unknown test problem designation' );
end
return
