%
% INSYDRV - INdefinite SYmmetric Lanczos TeSTer
%
%------------------------------------
%     Variable Definitions
%     ====================
%     Set by user:
%     AltForm        (logical) Determines linearization type used for quadratic
%                              eigenvalue problems.  See the remarks in the
%                              ``Further Details'' section.
%     Diagnostics    (logical) Turns on diagnostic computation/calculations. xxx
%     ERcorr         (logical) Turns on the Ericsson-Ruhe post processing step.
%                              See remarks in the ``Further Details'' section.
%     MustPreprocess (logical) If true, the initial vector is pre-multiplied
%                              by inv(A-sigma*B)*B.
%     iorthog        (string ) Reorthogonalization option: "none", "full",
%                              or "semi".
%     bdtol          (double ) Breakdown tolerance.
%     convtol        (double ) Convergence tolerance.
%     k              (integer) Lanczos loop counter.
%     m              (integer) Order of matrices in quadratic problems.
%     m2             (integer) Order of linearization of quadratic problems.
%     maxitr         (integer) Maximum number of Lanczos iterations.
%     mu             (double ) Norm of B*r, where r is the most recent
%                              unscaled Lanczos vector.
%     n              (integer) Order of A and of B.
%     nconv          (integer) Number of converged Ritz values.
%     nreorth        (integer) Number of reorthogonalization performed.
%     nu             (double ) Frobenius norm of B*Q_j. xxx
%     nwant          (integer) Number of wanted Ritz values.
%     orthtol        (double ) Reorthogonalization tolerance.
%     sigma          (complex) Shift value.
%     tau            (double ) Norm of r, the most recent unscaled Lanczos
%                              vector.
%     testprob       (integer) Test problem identification number.
%
%     B              (double ) 
%     Y              (double ) 
%     K              (double ) For quadratic problems, coefficient matrix of
%                              constant term.
%     C              (double ) For quadratic problems, coefficient matrix of
%                              linear term.
%     M              (double ) For quadratic problems, coefficient matrix of
%                              quadratic term.
%     L              (complex) Lower triangular factor of A-sigma*B (linear
%                              problems) or of K +sigma*C +sigma^2*M
%                              (quadratic problems).
%     Q              (complex) Matrix of Lanczos vectors.
%     T              (complex) Tridiagonal matrix.
%     That           (complex) Modified tridiagonal matrix. xxx
%     U              (complex) Upper triangular factor of A-sigma*B (linear
%                              problems) or of K +sigma*C +sigma^2*M
%                              (quadratic problems).
%     X              (complex) Ritz vectors (linear problems).
%     X1             (complex) Ritz vectors (quadratic problems).
%     X2             (complex) Ritz vectors (quadratic problems).
%     Z              (complex) Eigenvectors of pencil (T, Omega).
%     Zhat           (complex) Eigenvectors of That.
%
%     absomega       (double ) Absolute value of omega. xxx
%     alpha          (complex) Diagonal entries of T.
%     beta           (complex) Sub- and superdiagonal entries of T.
%     omega          (complex) Diagonal entries of Omega.
%     indcon         (integer) Indices of converged Ritz values.
%     pmomega        (complex) xxx
%     gamma          (complex) Algorithm residuals. xxx
%     pritz          (complex) Eigenvalues of (T, Omega).
%     r              (complex) Most recent unscaled Lanczos vector.
%
%
%     
count = 0;
save __junk__ count;
while (count < 12)
clear; format compact; format short e; randn('seed',1999);
load __junk__;
count = count+1;
testprob = count;
iorthog= 'full';             
if (testprob > 10)
   testprob = testprob-10;
   iorthog= 'semi';             
end
fprintf( '\n\t\t\t-->Starting test problem %i<--\n\n', testprob );
%
%--------Select test problem.
%
%testprob = 1; %----random linear
%testprob = 2; %----speaker107:
               %    quadratic eigenvalue problem from structural dynamics;
               %    order of quadratic problem: 107
%testprob = 3; %----random quadratic
%testprob = 4; %----shaft400
               %    quadratic eigenvalue problem from structural dynamics;
               %    order of quadratic problem: 400
               %    Both mass and damping matrix singular.
%testprob = 5; %----speaker334:
               %    quadratic eigenvalue problem from structural dynamics;
               %    order of quadratic problem: 334
%testprob = 6; %----defective symmetric pencil with prescribed eigenvalues;
               %    for now, will be complex if eigenvalues are complex, and
               %    each prescribed eigenvalue corresponds to 2 by 2 Jordan
               %    block of inv(K)*M.
%testprob = 7;  %----linear diagonal with singular B
%testprob = 8;  %----linear diagonal with nonsingular B
%testprob = 9;  %----shaft80
%testprob = 10;  %----speaker538;
[probtype,n,m,sigma,MustPreprocess,AltForm,aeig,A,B,K,C,M] =...
    getmat(testprob);
m2 = 2*m;
%
%--------Initialize some parameters
%
maxitr = min(n, 100);         %-------Maximum Lanczos iterations
bdtol  = 1.e-14;              %-------Breakdown tolerance
convtol= 1.e-8;               %-------Convergence tolerance
%iorthog= 'none';              %-------Reorthogonalization flag:
%iorthog= 'semi';              %-------Reorthogonalization flag:
%iorthog= 'full';              %-------Reorthogonalization flag:
                              %       iorthog = 'none' => no reorthogonalization
                              %       iorthog = 'full' ==> full orthogonality
                              %       iorthog = 'semi' ==> semi orthogonality
ERcorr = 0;                   %-------Flag to turn on Ericsson-Ruhe correction.
orthtol= 1.e-8;               %-------Reorthogonalization tolerance
nwant  =  5;                  %-------Number of desired eigenvalues
r      = ones(n,1);           %-------Initial vector.
%
Diagnostics = 1;              %-------Diagnostics flag: set to zero to turn off
                              %       expensive diagnostic computations such
                              %       as direct residual computations.
%
%--------Compute LU factorization of (A-sigma*B)
%
if (probtype=='linear   ')
   [L, U] = lu(A-sigma*B);
else
   [L, U] = lu(K + sigma*C + sigma^2*M);
end
%
%--------Call indefinite Lanczos procedure
%
[ k,nreorth,nconv,indcon,pritz,Z,res,alpha,beta,omega,r,Q,...
  rcond,elossval,xlossval ] = ...
   insylan( n, m, maxitr, nwant, probtype, AltForm, Diagnostics, ...
            MustPreprocess, iorthog, orthtol, convtol, bdtol, sigma, ...
            r, L, U, B, K, C, M );
%
%--------Compute eigenvectors and undo spectral transformation.
%
maxritz=1.0;
diff = 0.0;
if (nconv > 0)
   ritz = 1./pritz + sigma;
   maxritz = max(abs(ritz(indcon)));
   if (probtype=='linear   ')
      X = Q(:,1:k)*Z(:,indcon);
      for h = 1:nconv
          X(:,h) = X(:,h)/norm(X(:,h));
          dres(h) = norm(A*X(:,h) - ritz(indcon(h))*B*X(:,h));
          if (ERcorr)
             X(:,h) = X(:,h) + r/pritz(indcon(h))*Z(k,indcon(h));
             dresu(h) = dres(h);
             X(:,h) = X(:,h)/norm(X(:,h));
             dres(h) = norm(A*X(:,h) - ritz(indcon(h))*B*X(:,h),1);
          end
%          dres(h) = dres(h)/abs(ritz(indcon(h)));
          pdiff(h) = min( abs( pritz(indcon(h)) - (1./(aeig - sigma)) ) );
          diff(h) = min(abs( ritz(indcon(h)) - aeig ));
          if (abs(ritz(indcon(h)))>0.001*maxritz)
             diff(h) = diff(h)/abs(ritz(indcon(h)));
          end
      end
   else
%
%---------------The next for loop is for diagnostic purposes only; it
%               includes some expensive computations which should not be
%               included in a production code.
%
      if (Diagnostics)
         X = Q(:,1:k)*Z(:,indcon);
         for h=1:nconv
             normX(h) = norm(X(:,h));
             X(:,h) = X(:,h)/normX(h);
             w=zeros(m2,1);
             Gx=zeros(m2,1);
             Bx=zeros(m2,1);
             w(1:m) = C*X(1:m,h) + M*X(m+1:m2,h);
             w(m+1:m2) = M*X(1:m,h);
             Gx(1:m) = U \ ( L \ ( -w(1:m) - sigma*w(m+1:m2) ) );
             Gx(m+1:m2) = X(1:m,h) + sigma*Gx(1:m);
             pres(h) = norm( Gx - pritz(indcon(h))*X(:,h),2 );
             if (AltForm)
                Bx(1:m) = K*X(1:m,h);
                Bx(m+1:m2) = -M*X(m+1:m2,h);
             else
                Bx(1:m) = C*X(1:m,h) +M*X(m+1:m2,h);
                Bx(m+1:m2) = M*X(1:m,h);
             end
             condno(h) = norm(Bx) / abs( Bx.'*X(:,h) );
             errbnd(h) = condno(h)*pres(h);
%             estbnd(h) = abs(gamma(indcon(h)))/rcond(indcon(h)) * ...
%                         max( norm(Bx), normX(h)*nu/tau );
             pdiff(h) = min( abs( pritz(indcon(h)) - (1./(aeig - sigma)) ) );
         end  
      end
%
%-------------End diagnostic code
%
%      X = Q(1:m,1:k)*Z(:,indcon);
%      X = Q(:,1:k)*Z(:,indcon);
      X1 = Q(1:m,1:k)*Z(:,indcon);
      X2 = Q(m+1:m2,1:k)*Z(:,indcon);
%      X1 = X(1:m,:);
%      X2 = X(m+1:m2,:);
      for h = 1:nconv
          dres1(h) = norm(K*X1(:,h) + ritz(indcon(h))*C*X1(:,h)...
                         + ritz(indcon(h))^2*M*X1(:,h))/norm(X1(:,h));
          dres2(h) = norm(K*X2(:,h) + ritz(indcon(h))*C*X2(:,h)...
                         + ritz(indcon(h))^2*M*X2(:,h))/norm(X2(:,h));
          if (ERcorr)
             X1(:,h) = X1(:,h) + r(1:m)/pritz(indcon(h))*Z(k,indcon(h));
             X2(:,h) = X2(:,h) + r(m+1:m2)/pritz(indcon(h))*Z(k,indcon(h));
             dres1u(h) = dres1(h);
             dres2u(h) = dres2(h);
             dres1(h) = norm(K*X1(:,h) + ritz(indcon(h))*C*X1(:,h)...
                            + ritz(indcon(h))^2*M*X1(:,h))/norm(X1(:,h));
             dres2(h) = norm(K*X2(:,h) + ritz(indcon(h))*C*X2(:,h)...
                            + ritz(indcon(h))^2*M*X2(:,h))/norm(X2(:,h));
          end
          X2(:,h) = X2(:,h)/norm(X2(:,h));
          X1(:,h) = X1(:,h)/norm(X1(:,h));
          diff(h) = min(abs( ritz(indcon(h)) - aeig ));
          if (abs(ritz(indcon(h)))>0.001*maxritz)
             diff(h) = diff(h)/abs(ritz(indcon(h)));
          end
      end
   end
end
minrcond = min(rcond(indcon));
minrcond = max(minrcond,eps);
Ipass = ((nconv >= nwant)&(norm(diff(h))*sqrt(minrcond) < convtol));
fprintf( 'Test problem %i, ', testprob );
if (probtype=='quadratic')
   fprintf( 'which is a quadratic problem of order %i, ', m );
else
   fprintf( 'which is a linear problem of order %i, ', n );
end
if (Ipass)
   fprintf( 'has been successful.\n' );
else
   fprintf( 'has failed.\n' );
   Nwant_is = nwant
   Nfound_is =nconv
   Forward_Err = diff
   Rcond = rcond(indcon)
end
if (iorthog=='semi')
   fprintf( '\tSemi-orthogonality was maintained, \n\trequiring %i ', nreorth );
   fprintf( 'reorthogonalizations during %i Lanczos steps\n', k );
end
fprintf( '\n\n' );
save __junk__ count;
end %while
%
%--------Plot residuals, eigenvalues
%
%plot( real(aeig), imag(aeig), 'r+' );
%hold on;
%plot( real(ritz(indcon)), imag(ritz(indcon)), 'go' );
%hold off;
%pause;
%semilogy( dres, 'r+' );
%hold on;
%semilogy( res, 'go' );
%semilogy( diff, 'm*' );
%hold off;
exit;
