function   w = matvec( probtype, AltForm, m, r, B, K, C, M );
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% MATVEC - Matrix-vector multiply, w = B*r, where B may be implicitly or
%          explicitly formed.
%
% function   w = matvec( probtype, AltForm, m, r, B, K, C, M );
%------------------------------------------------------------------------------
%     Variable Descriptions
%     =====================
%
%     Input variables:
%     ----------------
%     probtype       (string ) probtype ='quadratic' if underlying problem is
%                              quadratic, and probtype ='linear   ' if 
%                              underlying problem is linear.
%     AltForm        (logical) Determines linearization type used for quadratic
%                              eigenvalue problems.  See the remarks in the
%                              ``Further Details'' below and in the file 
%                              insydrv.m.
%     m              (integer) Order of matrices in quadratic problems.
%                              see ``Further Details'' in file insydrv.m
%     r              (complex) (block of) vectors to be multiplied by B.
%     B              (double ) The B matrix. Not explicitly formed for 
%                              quadratic eigenvalue problems.
%     K              (double ) For quadratic problems, coefficient matrix of
%                              constant term.
%     C              (double ) For quadratic problems, coefficient matrix of
%                              linear term.
%     M              (double ) For quadratic problems, coefficient matrix of
%                              quadratic term.
%     Output variables:
%     -----------------
%     r              (complex) Product of B and r.
%     Further Details
%     ===============
%
%     When probtype='quadratic', then the matrix B is implicitly formed as
%     either   B = [ K  O ] when AltForm=true, or as
%                  [ O -M ]
%     B = [ C  M ] when AltForm=false.
%         [ M  O ]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ww = 0;
if (probtype=='linear   ')
   w = B*r;
else
   m2 = 2*m;
   if (AltForm) 
      w(1:m,:) = K*r(1:m,:);
      w(m+1:m2,:) = -M*r(m+1:m2,:);
   else
      w(1:m,:) = C*r(1:m,:) + M*r(m+1:m2,:);
      w(m+1:m2,:) = M*r(1:m,:);
   end
end
return
