#!/usr/bin/env python
import sys

if len(sys.argv) != 3:
	raise IOError, 'Usage: ./subset_restriction_enzyme_prototype_to_recognition_sequence_table_by_prototype_list.py prototype_to_recognition_sequence_table_file prototype_list_file'

def subset_restriction_enzyme_prototype_to_recognition_sequence_table_by_prototype_list(prototype_to_recognition_sequence_table_filename, prototype_list_filename):
	prototype_list = get_prototype_list(prototype_list_filename)

	prototype_to_recognition_sequence_table_file = open(prototype_to_recognition_sequence_table_filename, 'r')
	for line in prototype_to_recognition_sequence_table_file:
		line = line.strip()
		field_list = line.split('\t')
		prototype = field_list[0]

		# only select the lines that have a prototype from the prototype list
		if prototype in prototype_list:
			print line

def get_prototype_list(prototype_list_filename):
	prototype_list = []
	prototype_list_file = open(prototype_list_filename, 'r')
	for line in prototype_list_file:
		prototype = line.strip()
		if not (prototype in prototype_list):
			prototype_list.append(prototype)
	return prototype_list

subset_restriction_enzyme_prototype_to_recognition_sequence_table_by_prototype_list(sys.argv[1], sys.argv[2])
