#!/usr/bin/env python
# select_well_only_mutations_from_mutation_candidates_file.py
# Assumes that mutation candidates file does not contain a header

import sys
if len(sys.argv) != 3:
	raise IOError, 'Usage: ./select_well_only_mutations_from_mutation_candidates_file.py mutation_candidates_file pooling_dimension_string'

def select_well_only_mutations_from_mutation_candidates_file(mutation_candidates_filename, pooling_dimension_string):
	if int(pooling_dimension_string) == 2:
		use_3D_pooling = False
	elif int(pooling_dimension_string) == 3:
		use_3D_pooling = True
	else:
		raise IOError, 'Unexpected pooling scheme dimension: %d' % pooling_dimension_string

	mutation_candidates_file = open(mutation_candidates_filename, 'r')
	for line in mutation_candidates_file:
		line = line.strip()
		field_list = line.split('\t')
		row_library = field_list[5]
		column_library = field_list[6]
		if use_3D_pooling:
			d_library = field_list[7]

		if (((not use_3D_pooling) and (row_library != 'NA') and (column_library != 'NA')) or \
		    (use_3D_pooling and (row_library != 'NA') and (column_library != 'NA') and (d_library != 'NA'))):
			# well mutation
			print line

select_well_only_mutations_from_mutation_candidates_file(sys.argv[1], sys.argv[2])
