#!/usr/bin/env python

import sys

from math import log, exp, pow

def mean(list):
	sum_x = 0
	for x in list:
		sum_x += x
	mean_x = float(sum_x) / float(len(list))
	return mean_x

def sample_variance(list):
	mean_x = mean(list)

	sum_sq_diff_x = 0
	for x in list:
		sum_sq_diff_x += pow(x - mean_x, 2.0)
	result = float(sum_sq_diff_x) / float(len(list) - 1)
	return result

############### Hypergeometric Distribution ###################

# first two functions are copied off of web,
# written by Steven D'Aprano and Scott David Daniels
def raw_bincoeff1(n,r):
	if r < n - r:
		r = n - r
	x = 1
	for i in range(n, r, -1):
		x *= i
	for i in range(n - r, 1, -1):
		x /= i
	return x

def dhyper(k, n1, n2, t):
	if t > n1 + n2:
		t = n1 + n2
	if k > n1 or k > t:
		return 0
	elif t > n2 and ((k + n2) < t):
		return 0
	else:
		c1 = log(raw_bincoeff1(n1,k))
		c2 = log(raw_bincoeff1(n2, t - k))
		c3 = log(raw_bincoeff1(n1 + n2 ,t))
		return exp(c1 + c2 - c3)

# phyper is written by me, using dhyper as a black box
# This is equivalent to the phyper in R
def phyper(x, n1, n2, t):
	total_prob = 0.0
	for k in range(0, x+1):
		total_prob += dhyper(k, n1, n2, t)
	return total_prob

##################### Binomial Distribution ##################

def dbinom(i, n, p):
	return raw_bincoeff1(n,i) * pow(p, i) * pow((1-p), (n-i))

# probability of choosing 0 to x out of n elements,
# when independent probability of choosing each element is p
def pbinom(x, n, p):
	total_prob = 0.0
	for i in range(0, x+1):
		total_prob += dbinom(i, n, p)
	return total_prob

