#!/usr/bin/env python

import sys, math

if len(sys.argv) != 3:
	raise IOError, 'Usage: ./transform_scores_for_bayesian_method_candidates_file.py mutation_candidates_file num_dimensions_in_pooling_scheme'

def transform_scores_for_bayesian_method_candidates_file(mutation_candidates_filename, num_dimensions_in_pooling_scheme_string):
	## select the correct indices in the mutation candidates file, depending on if we are using a 2D or 3D pooling scheme
	if int(num_dimensions_in_pooling_scheme_string) == 2:
		index_correction_for_gained_and_lost_thresholds = 0
	elif int(num_dimensions_in_pooling_scheme_string) == 3:
		index_correction_for_gained_and_lost_thresholds = 5
	else:
		raise IOError, 'Unexpected pooling scheme dimension: %s' % num_dimensions_in_pooling_scheme_string

	mutation_candidates_file = open(mutation_candidates_filename, 'r')
	for line in mutation_candidates_file:
		line = line.rstrip('\n\r')
		field_list = line.split('\t')

		for i in [4, (21 + index_correction_for_gained_and_lost_thresholds), (22 + index_correction_for_gained_and_lost_thresholds)]:
			field_list[i] = transform_score_string(field_list[i])
		line = '\t'.join(field_list)
		print line
	return

def transform_score_string(score_string):
	if (score_string == 'NA') or (score_string == 'nan'):
		new_score_string = score_string
	else:
		score = float(score_string)
		## Temporary error checking code:
		if (score < - 1e-12) or (score > 1 + 1e-12):
			raise IOError, 'Score should be between 0 and 1 (or at least to some precision)'
		if score <= 0.0:
			new_score_string = 'Inf'
			#raise IOError, 'Error: script currently cannot handle posterior probability of 0%'
		elif score >= 1.0:
			new_score_string = '-Inf'
		else:
			new_score = transform_score(score)
			new_score_string = '%f' % new_score
	return new_score_string

def transform_score(score):
	if score <= 0.5:
		new_score = (- (math.log(score, 10.0) - math.log(0.5, 10.0)))
	else:
		new_score = math.log(1.0 - score, 10.0) - math.log(0.5, 10.0)
	return new_score

transform_scores_for_bayesian_method_candidates_file(sys.argv[1], sys.argv[2])
