#!/bin/bash

#$ -cwd
#$ -S /bin/bash
#$ -M vmissirian@ucdavis.edu

# insert job commands below ...


if [ $# -ne 2 ]
then
	echo "Usage: ./subset_all_pileup.outs.sh run_number coverage_fraction"
	exit
fi

run_number=$1
coverage_fraction=$2

echo Run number=$run_number, coverage_fraction=$coverage_fraction.

original_directory=Tilling${run_number}
subset_directory=Tilling${run_number}_coverage_fraction_${coverage_fraction}

## Copy over parsed pileups for each library
pushd $original_directory
library_string=`ls -d T${run_number}[RC]*`
library_list=( ${library_string} )
popd

echo In ${original_directory}, found libraries: ${library_string}

mkdir $subset_directory
pushd $subset_directory

for library in ${library_list[*]}; do
	mkdir $library
	pushd $library
	echo In directory ${library}:
	../../subset_pileup.out.py ../../${original_directory}/${library}/pileup.out pileup.out fraction $coverage_fraction
	popd
done

popd

## Copy over other important files 
cp -p ${original_directory}/List_of_genes_and_homologs_by_organism $subset_directory
#cp -p ${original_directory}/concatenate_all_parsed_pileups.sh $subset_directory
cp -p ${original_directory}/README $subset_directory
cp -rp ${original_directory}/Sequence_Files $subset_directory
cp -p ${original_directory}/sequence_URL_file $subset_directory


echo Finished processing!


