#!/bin/sh

if [ $# -ne 1 ]; then
	echo 'Usage: ./concatenate_all_parsed_pileups.sh tilling_run_number'
	exit
fi

tilling_run_number=$1


lane_list=( `ls -d T[0-9]*[CR][0-9]*` )

mkdir Parsed_Pileup
parsed_pileup_file=Parsed_Pileup/T${tilling_run_number}_parsed_pileup.txt

cat ../misc/parse_pileup_header_Dec_1st_2008 > ${parsed_pileup_file}
for lane in ${lane_list[*]}; do
	pushd $lane
	echo In directory ${lane}:
	cat parsed_pileup.txt >> ../${parsed_pileup_file}
	popd
done
echo Finished processing!


