#!/usr/bin/env python

import sys
import fasta_file_helper_functions
import sequence_processing__module
import locus__helper_functions

if len(sys.argv) != 6:
	raise IOError, 'Usage: ./print_n_random_reads_of_length_x_from_subset_of_sequences_in_fasta_file_to_output_file.py [ num_reads_to_select(i.e. 100) | coverage(i.e. 4.0x) ] read_length sequence_name_file fasta_file output_file'

def main(num_reads_to_select_string, read_length_string, sequence_name_filename, fasta_filename, output_filename):
	read_length = int(read_length_string)

	name_to_sequence_dict = fasta_file_helper_functions.get_name_to_sequence_dict_from_fasta_file(fasta_filename)


	sequence_name_dict = locus__helper_functions.get_locus_dict_from_file(sequence_name_filename)

	file_option='w'
	for sequence_name in sequence_name_dict:
		sequence_processing__module.print_n_random_reads_of_length_x_from_specific_sequence_to_output_file(num_reads_to_select_string, read_length, sequence_name,
														name_to_sequence_dict, output_filename, file_option)
		file_option='a'
	return

main(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5])
