#!/usr/bin/env python

import sys
import fasta_file_helper_functions

if len(sys.argv) != 4:
	raise IOError, 'Usage: ./randomly_print_n_sequence_names_from_fasta_file_to_output_file.py num_sequence_names_to_select fasta_file output_file'

def main(num_sequence_names_to_select_string, fasta_filename, output_filename):
	print 'DEBUG: in main() of randomly_print_n_sequence_names_from_fasta_file_to_output_file.py\n'

	if (num_sequence_names_to_select_string != 'all') and (int(num_sequence_names_to_select_string) < 0):
		raise IOError, 'Number of sequence names to select cannot be less than 0'

	name_to_sequence_dict = fasta_file_helper_functions.get_name_to_sequence_dict_from_fasta_file(fasta_filename)
	sequence_name_list = name_to_sequence_dict.keys()
	
	if num_sequence_names_to_select_string == 'all':
		num_sequence_names_to_select = num_sequence_names_to_select_string
		output_file = open(output_filename, 'w')
		for i in range(0, length(sequence_name_list)):
			output_file.write(sequence_name_list[i] + '\n')
		output_file.close()
	else:
		num_sequence_names_to_select = int(num_sequence_names_to_select_string)

		output_file = open(output_filename, 'w')
        
		num_sequence_names_printed = 0
		while num_sequence_names_printed < num_sequence_names_to_select:
			num_unselected_sequence_names = len(sequence_name_list)
			if num_unselected_sequence_names < num_sequence_names_to_select:
				raise IOError, 'Cannot select %d sequence names, since there are only %d sequence names in fasta file' % \
						(num_sequence_names_to_select, num_unselected_sequence_names)
        
			index_to_remove = fasta_file_helper_functions.get_random_index(num_unselected_sequence_names)
        
			## write selected sequence name to output file
			output_file.write(sequence_name_list[index_to_remove] + '\n')
        
			num_sequence_names_printed += 1
        
			## remove selected sequence name
			sequence_name_list = sequence_name_list[:index_to_remove] + sequence_name_list[(index_to_remove + 1):]
		
		output_file.close()
	return

main(sys.argv[1], sys.argv[2], sys.argv[3])
