#!/usr/bin/env python
import sys

def get_base_chromosome_name(chr):
	chr = chr.strip()
	chr = chr.lower()
	while 'chr' in chr:
		chr = chr.replace('chr', '')
	
	if ('chloroplast' in chr) or (chr == 'c'):
		base_chr = 'chrC'
	elif ('mitochondria' in chr) or ('mitochondrion' in chr) or (chr == 'm'):
		base_chr = 'chrM'
	else:
		base_chr = 'chr%s' % chr.upper()
	return base_chr
