#!/usr/bin/env python
import sys, math, random

def get_name_to_sequence_dict_from_fasta_file(fasta_filename):
	sequence_name, sequence = -1, -1
	name_to_sequence_dict = {}

	line_count = 0

	fasta_file = open(fasta_filename, 'r')
	print 'DEBUG: in get_name_to_sequence_dict_from_fasta_file()\n'
	for line in fasta_file:
		line_count += 1
		if (line_count % 100000) == 0:
			print 'In get_name_to_sequence_dict_from_fasta_file: on line %d of fasta file\n' % line_count

		line = line.rstrip('\n\r')
		if line == '':
			continue
		elif line[0] == '>':
			if sequence != -1:
				name_to_sequence_dict[sequence_name] = sequence

			sequence_name = line.replace('>', '').strip().split()[0]
			if sequence_name in name_to_sequence_dict:
				raise IOError, 'Found the same sequence name (%s) twice in fasta file' % sequence_name
			sequence = ''
		else:
			sequence += line.strip()
	if sequence != -1:
		name_to_sequence_dict[sequence_name] = sequence

	return name_to_sequence_dict

def get_random_mask(num_indices_to_label_true, mask_length):
	if num_indices_to_label_true > mask_length:
		raise IOError, 'num_indices_to_label_true (%d) is greater than mask_length (%d)' % (num_indices_to_label_true, mask_length)
	index_list = range(0, mask_length)
	num_indices_to_select_from = len(index_list)

	selected_index_dict = {}
	num_selected_indices = 0
	while num_selected_indices < num_indices_to_label_true:
		index_of_index = get_random_index(num_indices_to_select_from)
		## add selected index to new list
		selected_index = index_list[index_of_index]
		if selected_index in selected_index_dict:
			raise IOError,'Unexpected - selected the same index two times'
		selected_index_dict[selected_index] = 0
		
		## remove selected index from old list
		index_list = index_list[0:index_of_index] + index_list[(index_of_index+1):]
		## update number of selected indices and number of remaining indices
		num_selected_indices += 1
		num_indices_to_select_from -= 1
	
	mask = []
	for index in range(0, mask_length):
		if index in selected_index_dict:
			mask.append(True)
		else:
			mask.append(False)
	return mask

def get_random_index(n):
	index = -1
	while (index < 0) or ((n-1) < index):
		index = int(math.floor(random.random() * n))
	return index


