#!/usr/bin/env python
import sys

#num_reads = 100

if len(sys.argv) != 9:
	raise IOError, 'Usage: ./get_good_orthologs.py ref_to_refP_mapping_file ref_to_otherP_mapping_file refP_to_ref_mapping_file refP_to_otherP_mapping_file otherP_to_ref_mapping_file otherP_to_refP_mapping_file num_reads_to_map_well ortholog_output_file'

def get_good_orthologs(ref_to_refP_mapping_filename, ref_to_otherP_mapping_filename, refP_to_ref_mapping_filename, refP_to_otherP_mapping_filename,
			otherP_to_ref_mapping_filename, otherP_to_refP_mapping_filename, num_reads_to_map_well_string, ortholog_output_filename):
	## get number of reads to map well
	num_reads_to_map_well = int(num_reads_to_map_well_string)

	ref_to_refP_dict = get_strong_x_to_y_mappings(ref_to_refP_mapping_filename, num_reads_to_map_well)
	ref_to_otherP_dict = get_strong_x_to_y_mappings(ref_to_otherP_mapping_filename, num_reads_to_map_well)
	refP_to_ref_dict = get_strong_x_to_y_mappings(refP_to_ref_mapping_filename, num_reads_to_map_well)
	refP_to_otherP_dict = get_strong_x_to_y_mappings(refP_to_otherP_mapping_filename, num_reads_to_map_well)
	otherP_to_ref_dict = get_strong_x_to_y_mappings(otherP_to_ref_mapping_filename, num_reads_to_map_well)
	otherP_to_refP_dict = get_strong_x_to_y_mappings(otherP_to_refP_mapping_filename, num_reads_to_map_well)


	## print out strong ortholog triples to the output file
	ortholog_output_file = open(ortholog_output_filename, 'w')

	## find each locus in ref that has a strong mapping to a locus in refP and a locus in otherP
	for ref in ref_to_refP_dict:
		if not (ref in ref_to_otherP_dict):
			continue
		refP = ref_to_refP_dict[ref]
		otherP = ref_to_otherP_dict[ref]
		
		## check that the loci for refP and otherP map strongly back to the locus for ref
		if (not (refP in refP_to_ref_dict)) or (not (otherP in otherP_to_ref_dict)):
			continue
		if (refP_to_ref_dict[refP] != ref) or (otherP_to_ref_dict[otherP] != ref):
			continue

		## check that the loci for refP and otherP map strongly to each other
		if (not (refP in refP_to_otherP_dict)) or (not (otherP in otherP_to_refP_dict)):
			continue
		if (refP_to_otherP_dict[refP] != otherP) or (otherP_to_refP_dict[otherP] != refP):
			continue
		
		## if all these checks have cleared,
		## then we have a one-to-one-to-one strongly mapping ortholog triple
		ortholog_output_file.write('%s\t%s\t%s\n' % (ref, refP, otherP))
	ortholog_output_file.close()
	return

def get_strong_x_to_y_mappings(x_to_y_mapping_filename, num_reads_to_map_well):
	x_to_y_mapping_file = open(x_to_y_mapping_filename, 'r')
	strong_x_to_y_dict = {}
	x_dict= {}
	for line in x_to_y_mapping_file:
		line = line.rstrip('\n\r')
		field_list = line.split('\t')
		x = field_list[0]
		if x == 'query.sequence.name':
			## header line
			continue
		if x in x_dict:
			raise IOError, 'unexpected: saw x twice'
		x_dict[x] = 0
		best_y = field_list[1]
		num_reads_for_best_y = int(field_list[3])
		if num_reads_for_best_y >= num_reads_to_map_well:
			## strong mapping
			strong_x_to_y_dict[x] = best_y
	x_to_y_mapping_file.close()
	return strong_x_to_y_dict

get_good_orthologs(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6], sys.argv[7], sys.argv[8])
