# read.count.frequency.distribution.helper.functions.R

library(hash)

"get.regular.and.allele.specific.counts.from.set.of.statistics.per.locus.files" <- function(statistics.per.locus.file.array){
	## get allele specific counts for each locus

	locus.to.num.reads.hashtable <- hash()
	locus.to.num.ref.hashtable <- hash()
	locus.to.num.other.hashtable <- hash()
	for(statistics.per.locus.file in statistics.per.locus.file.array){
		update.regular.and.allele.specific.counts.for.statistics.per.locus.file(statistics.per.locus.file, locus.to.num.reads.hashtable, locus.to.num.ref.hashtable, locus.to.num.other.hashtable)
	}

	## assume same set of loci in each hashtable

	locus.array <- rownames(as.matrix(as.list.hash(locus.to.num.ref.hashtable)))
	sorted.locus.array <- sort(locus.array)

	list(locus.to.num.reads.hashtable=locus.to.num.reads.hashtable, locus.to.num.ref.hashtable=locus.to.num.ref.hashtable,
	     locus.to.num.other.hashtable=locus.to.num.other.hashtable, sorted.locus.array=sorted.locus.array)
}

"update.regular.and.allele.specific.counts.for.statistics.per.locus.file" <- function(statistics.per.locus.file, locus.to.num.reads.hashtable, locus.to.num.ref.hashtable, locus.to.num.other.hashtable){
	table <- read.table(statistics.per.locus.file, header=TRUE, sep="\t")
	locus.array <- data.matrix(table[,1])
	num.reads.array <- data.matrix(table[,2])
	num.ref.array <- data.matrix(table[,4])
	num.other.array <- data.matrix(table[,5])
	for(i in 1:length(locus.array)){
		locus <- locus.array[i]
		num.reads <- num.reads.array[i]
		num.ref <- num.ref.array[i]
		num.other <- num.other.array[i]

		## update num reads mapping to ref allele for current locus
		locus.to.num.reads.hashtable[[locus]]
		if(length(locus.to.num.reads.hashtable[[locus]]) == 0){
			locus.to.num.reads.hashtable[[locus]] <- 0
		}
		locus.to.num.reads.hashtable[[locus]] <- locus.to.num.reads.hashtable[[locus]] + num.reads
		
		## update num reads mapping to ref allele for current locus
		locus.to.num.ref.hashtable[[locus]]
		if(length(locus.to.num.ref.hashtable[[locus]]) == 0){
			locus.to.num.ref.hashtable[[locus]] <- 0
		}
		locus.to.num.ref.hashtable[[locus]] <- locus.to.num.ref.hashtable[[locus]] + num.ref
		
		## update num reads mapping to other allele for current locus
		if(length(locus.to.num.other.hashtable[[locus]]) == 0){
			locus.to.num.other.hashtable[[locus]] <- 0
		}
		locus.to.num.other.hashtable[[locus]] <- locus.to.num.other.hashtable[[locus]] + num.other
	}
}


