#!/bin/sh

## Call SNPs from samtools bam file, as described in "http://samtools.sourceforge.net/mpileup.shtml" as of 3/1/2011 (last modified 12/17/2010)

if [ $# -ne 3 ]; then
	echo ./samtools2SNP.sh reference_file bam_file output_file_basename
	exit
fi

ref_file=$1
bam_file=$2
output_file_basename=$3

samtools mpileup -uf ${ref_file} ${bam_file} | bcftools view -bvcg - > ${output_file_basename}.raw.bcf
bcftools view ${output_file_basename}.raw.bcf | vcfutils.pl varFilter -D100 > ${output_file_basename}.flt.vcf
