/* 
**++
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      globals_m.h -- header file with global declarations and definitions.
**      For use in the main program file only (xparal.c).
**      A matching header file  (globals_s.h) with extern declarations is of
**      all varaibles declared here is to be used in all other modules.
**
**  AUTHORS:
**      Paul F. Stelling
**      Jim Knight
**      Justin Bronder
**      Douglas Mayfield
**      K. Balasubramanian
**
**  CREATION DATE:      04/25/1991
**
**  MODIFICATION HISTORY:
**
**      05/02/91        J. Bronder      use Motif widgets
**      1992-1995       P. Stelling     corrected and improved
**                                        algorithmic approach
**                                        (including new/revised data structures)
**                                      read strings from file
**                                      reverse strings
**                                      specify region
**                                      output performance statistics (log)
**                                      save alignment/polygon info to a file
**      1994            J. Knight       remove Motif -- use all Xt Intrinsics
**      1995            P. Stelling     read in a reference alignment
**                                      compute values for input alignment
**                                        and display them
**
*/

struct stat     log_buf;
char            *log_fname;
FILE            *log_fp;

/************************************************************************/
/*                                                                      */
/*  Set up the string matching global variables                         */
/*                                                                      */
/************************************************************************/

unsigned char   *str1 = 0,
                *str2 = 0;
int             len1,
                len2;
int             opt_function,
                scoring_method,
                with_gaps;	/* 0 = no gaps, 1  = with gaps */
/* added for convex gaps */

int             convex=0;	/* 0 = not convex, 1  = convex */
stpoint		*gst;

int		gsp;

double		convex_y=1.0;
double		convex_w=1.0;

double          *gap_size_weight;
int             max_gap_size=0;

int             have_minval_poly = 0,
                number_corners = 0,
                number_opts = 0,
                number_polys = 0;
int             weights_in_array = 0;

double          *weight_matrix_array;
double          maxval_x = 0.0,
                maxval_y = 0.0;
double          minval_x = 0.0,
                minval_y = 0.0;
double          Global_v = 1.0,
                Global_w = 1.0;

Funct           *display_fun = NULL,
                *input_fun = NULL;

Funct_list      *fun_list = NULL;

Max_node        *array = NULL;

Point           *display_pt = NULL,
                *display_fun_pt = NULL;

char            *align_path = NULL,
                *align_path_last = NULL;
int             align_number;
int             align_end_array_i,
                align_end_array_j,
                align_start_array_i,
                align_start_array_j;
double          align_max_val;

Poly            *dark_poly = NULL,
                *last_poly = NULL,
                *poly_list = NULL;
Todo            *todo_list = NULL;

Cursor          hourglass;

Widget          toplevel,
                input_align_diff_label;

Image_data      hack_data,
                *my_data;

const char            *inputaligndiff_blank =
                        "                                   \n \n \n \n \n ";
const char            *inputaligndiff_noinput =
                        "At Point    X:    %15.8f\n"
                        "            Y:    %15.8f\n\n"
                        "Optimal Value:    %15.8f\n"
                        " \n ";
const char            *inputaligndiff =
                        "At Point    X:    %15.8f\n"
                        "            Y:    %15.8f\n\n"
                        "Optimal Value:    %15.8f\n"
                        "Input Align Value:%15.8f\n"
                        "Difference:       %15.8f";

/* convex n^2logn implementation lists */
lpoint      *elist, **flist;

int	    ept, *fpt;

const char *PAM250_MAT = 
"Name: Dayhoff's PAM 250\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
   2\n\
   0   2\n\
  -2  -4  12\n\
   0   3  -5   4\n\
   0   2  -5   3   4\n\
  -4  -5  -4  -6  -5   9\n\
   1   0  -3   1   0  -5   5\n\
  -1   1  -3   1   1  -2  -2   6\n\
  -1  -2  -2  -2  -2   1  -3  -2   5\n\
   0   0   0   0   0   0   0   0   0   0\n\
  -1   1  -5   0   0  -5  -2   0  -2   0   5\n\
  -2  -3  -6  -4  -3   2  -4  -2   2   0  -3   6\n\
  -1  -2  -5  -3  -2   0  -3  -2   2   0   0   4   6\n\
   0   2  -4   2   1  -4   0   2  -2   0   1  -3  -2   2\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
   1  -1  -3  -1  -1  -5  -1   0  -2   0  -1  -3  -2  -1   0   6\n\
   0   1  -5   2   2  -5  -1   3  -2   0   1  -2  -1   1   0   0   4\n\
  -2  -1  -4  -1  -1  -4  -3   2  -2   0   3  -3   0   0   0   0   1   6\n\
   1   0   0   0   0  -3   1  -1  -1   0   0  -3  -2   1   0   1  -1   0   2\n\
   1   0  -2   0   0  -3   0  -1   0   0   0  -2  -1   0   0   0  -1  -1   1   3\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
   0  -2  -2  -2  -2  -1  -1  -2   4   0  -2   2   2  -2   0  -1  -2  -2  -1   0   0   4\n\
  -6  -5  -8  -7  -7   0  -7  -3  -5   0  -3  -2  -4  -4   0  -6  -5   2  -2  -5   0  -6  17\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
  -3  -3   0  -4  -4   7  -5   0  -1   0  -4  -1  -2  -2   0  -5  -4  -4  -3  -3   0  -2   0   0  10\n\
   0   2  -5   3   3  -5  -1   2  -2   0   0  -3  -2   1   0   0   3   0   0  -1   0  -2  -6   0  -4   3";

const char *PAM250_8_MAT = 
"Name: Dayhoff's PAM 250 Plus 8\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
 10\n\
  8 10\n\
  6  4 20\n\
  8 11  3 12\n\
  8 10  3 11 12\n\
  4  3  4  2  3 17\n\
  9  8  5  9  8  3 13\n\
  7  9  5  9  9  6  6 14\n\
  7  6  6  6  6  9  5  6 13\n\
  8  8  8  8  8  8  8  8  8  8\n\
  7  9  3  8  8  3  6  8  6  8 13\n\
  6  5  2  4  5 10  4  6 10  8  5 14\n\
  7  6  3  5  6  8  5  6 10  8  8 12 14\n\
  8 10  4 10  9  4  8 10  6  8  9  5  6 10\n\
  8  8  8  8  8  8  8  8  8  8  8  8  8  8  8\n\
  9  7  5  7  7  3  7  8  6  8  7  5  6  7  8 14\n\
  8  9  3 10 10  3  7 11  6  8  9  6  7  9  8  8 12\n\
  6  7  4  7  7  4  5 10  6  8 11  5  8  8  8  8  9 14\n\
  9  8  8  8  8  5  9  7  7  8  8  5  6  9  8  9  7  8 10\n\
  9  8  6  8  8  5  8  7  8  8  8  6  7  8  8  8  7  7  9  11\n\
   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8\n\
   8   6   6   6   6   7   7   6  12   8   6  10  10   6   8   7   6   6   7   8   8  12\n\
   2   3   0   1   1   8   1   5   3   8   5   6   4   4   8   2   3  10   6   3   8   2  25\n\
   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8\n\
   5   5   8   4   4  15   3   8   7   8   4   7   6   6   8   3   4   4   5   5   8   6   8   8  18\n\
   8  10   3  11  11   3   7  10   6   8   8   5   6   9   8   8  11   8   8   7   8   6   2   8   4  11";

const char *BLOSUM80_MAT =
"Name: BLOSUM 80\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
 5\n\
-2  5\n\
-1 -4  9\n\
-2  5 -4  6\n\
-1  1 -5  1  6\n\
-3 -4 -3 -4 -4  6\n\
 0 -1 -4 -2 -3 -4  6\n\
-2 -1 -4 -2  0 -2 -3  8\n\
-2 -4 -2 -4 -4 -1 -5 -4  5\n\
-2 -4 -2 -5 -4  0 -5 -4  3  3\n\
-1 -1 -4 -1  1 -4 -2 -1 -3 -3  5\n\
-2 -4 -2 -5 -4  0 -4 -3  1  3 -3  4\n\
-1 -3 -2 -4 -2  0 -4 -2  1  2 -2  2  6\n\
-2  5 -3  1 -1 -4 -1  0 -4 -4  0 -4 -3  6\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
-1 -2 -4 -2 -2 -4 -3 -3 -4 -4 -1 -3 -3 -3  0  8\n\
-1  0 -4 -1  2 -4 -2  1 -3 -3  1 -3  0  0  0 -2  6\n\
-2 -1 -4 -2 -1 -4 -3  0 -3 -3  2 -3 -2 -1  0 -2  1  6\n\
 1  0 -2 -1  0 -3 -1 -1 -3 -3 -1 -3 -2  0  0 -1  0 -1  5\n\
 0 -1 -1 -1 -1 -2 -2 -2 -1 -1 -1 -2 -1  0  0 -2 -1 -1  1  5\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
 0 -4 -1 -4 -3 -1 -4 -4  3  2 -3  1  1 -4  0 -3 -3 -3 -2  0  0  4\n\
-3 -5 -3 -6 -4  0 -4 -3 -3 -3 -4 -2 -2 -4  0 -5 -3 -4 -4 -4  0 -3  11\n\
-1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0 -1 -1 -1 -1 -1  0 -1 -1 -1\n\
-2 -3 -3 -4 -3  3 -4  2 -2 -2 -3 -2 -2 -3  0 -4 -2 -3 -2 -2  0 -2  2 -1  7\n\
-1  0 -4  1  5 -4 -3  0 -4 -3  1 -3 -1  0  0 -2  4  0  0 -1  0 -3 -3 -1 -3  5";

const char *BLOSUM62_MAT =
"Name: BLOSUM 62\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
 4\n\
-2  4\n\
 0 -3  9\n\
-2  4 -3  6\n\
-1  1 -4  2  5\n\
-2 -3 -2 -3 -3  6\n\
 0 -1 -3 -1 -2 -3  6\n\
-2  0 -3 -1  0 -1 -2  8\n\
-1 -3 -1 -3 -3  0 -4 -3  4\n\
-1 -3 -1 -3 -3  0 -4 -3  3  3\n\
-1  0 -3 -1  1 -3 -2 -1 -3 -3  5\n\
-1 -4 -1 -4 -3  0 -4 -3  2  3 -2  4\n\
-1 -3 -1 -3 -2  0 -3 -2  1  2 -1  2  5\n\
-2  4 -3  1  0 -3  0  1 -3 -3  0 -3 -2  6\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
-1 -2 -3 -1 -1 -4 -2 -2 -3 -3 -1 -3 -2 -2  0  7\n\
-1  0 -3  0  2 -3 -2  0 -3 -2  1 -2  0  0  0 -1  5\n\
-1 -1 -3 -2  0 -3 -2  0 -3 -2  2 -2 -1  0  0 -2  1  5\n\
 1  0 -1  0  0 -2  0 -1 -2 -2  0 -2 -1  1  0 -1  0 -1  4\n\
 0 -1 -1 -1 -1 -2 -2 -2 -1 -1 -1 -1 -1  0  0 -1 -1 -1  1  5\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
 0 -3 -1 -3 -2 -1 -3 -3  3  2 -2  1  1 -3  0 -2 -2 -3 -2  0  0  4\n\
-3 -4 -2 -4 -3  1 -2 -2 -3 -2 -3 -2 -1 -4  0 -4 -2 -3 -3 -2  0 -3 11\n\
-1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0 -1 -1 -1 -1 -1  0 -1 -1 -1\n\
-2 -3 -2 -3 -2  3 -3  2 -1 -1 -2 -1 -1 -2  0 -3 -1 -2 -2 -2  0 -1  2 -1  7\n\
-1  0 -3  1  4 -3 -2  0 -3 -3  1 -3 -1  0  0 -1  4  0  0 -1  0 -2 -2 -1 -2  4";

const char *BLOSUM45_MAT =
"Name: BLOSUM 45\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
 5\n\
-1  5\n\
-1 -2 12\n\
-2  6 -3  7\n\
-1  1 -3  2  6\n\
-2 -3 -2 -4 -3  8\n\
 0 -1 -3 -1 -2 -3  7\n\
-2  0 -3  0  0 -2 -2 10\n\
-1 -3 -3 -4 -3  0 -4 -3  5\n\
-1 -3 -2 -3 -3  1 -4 -2  4  4\n\
-1  0 -3  0  1 -3 -2 -1 -3 -3  5\n\
-1 -3 -2 -3 -2  1 -3 -2  2  4 -3  5\n\
-1 -2 -2 -3 -2  0 -2  0  2  2 -1  2  6\n\
-1  5 -2  2  0 -2  0  1 -2 -3  0 -3 -2  6\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
-1 -2 -4 -1  0 -3 -2 -2 -2 -3 -1 -3 -2 -2  0  9\n\
-1  0 -3  0  2 -4 -2  1 -2 -2  1 -2  0  0  0 -1  6\n\
-2 -1 -3 -1  0 -2 -2  0 -3 -3  3 -2 -1  0  0 -2  1  7\n\
 1  0 -1  0  0 -2  0 -1 -2 -2 -1 -3 -2  1  0 -1  0 -1  4\n\
 0  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -1  0  0 -1 -1 -1  2  5\n\
 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0\n\
 0 -3 -1 -3 -3  0 -3 -3  3  2 -2  1  1 -3  0 -3 -3 -2 -1  0  0  5\n\
-2 -4 -5 -4 -3  1 -2 -3 -2 -2 -2 -2 -2 -4  0 -3 -2 -2 -4 -3  0 -3 15\n\
-1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0 -1 -1 -1 -1 -1  0 -1 -1 -1\n\
-2 -2 -3 -2 -2  3 -3  2  0  0 -1  0  0 -2  0 -3 -1 -1 -2 -1  0 -1  3 -1  8\n\
-1  1 -3  1  5 -3 -2  0 -3 -2  1 -2 -1  0  0 -1  4  1  0 -1  0 -3 -2 -1 -2  5";

const char *GONNET_MAT = 
"Name: Gonnet's Matrix\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
 24\n\
  0   0\n\
 05   0 115\n\
-03   0 -32  47\n\
  0   0 -30  27  36\n\
-23   0 -08 -45 -39  70\n\
 05   0 -20  01 -08 -52  66\n\
-08   0 -13  04  04 -01 -14  60\n\
-08   0 -11 -38 -27  10 -45 -22  40\n\
  0   0   0   0   0   0   0   0   0   0\n\
-04   0 -28  05  12 -33 -11  06 -21   0  32\n\
-12   0 -15 -40 -28  20 -44 -19  28   0 -21  40\n\
-07   0 -09 -30 -20  16 -35 -13  25   0 -14  28  43\n\
-03   0 -18  22  09 -31  04  12 -28   0  08 -30 -22  38\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
 03   0 -31 -07 -05 -38 -16 -11 -26   0 -06 -23 -24 -09   0  76\n\
-02   0 -24  09  17 -26 -10  12 -19   0  15 -16 -10  07   0 -02  27\n\
-06   0 -22 -03  04 -32 -10  06 -24   0  27 -22 -17  03   0 -09  15  47\n\
 11   0  01  05  02 -28  04 -02 -18   0  01 -21 -14  09   0  04  02 -02  22\n\
 06   0 -05   0 -01 -22 -11 -03 -06   0  01 -13 -06  05   0  01   0 -02  15  25\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
 01   0   0 -29 -19  01 -33 -20  31   0 -17  18  16 -22   0 -18 -15 -20 -10   0   0  34\n\
-36   0 -10 -52 -43  36 -40 -08 -18   0 -35 -07 -10 -36   0 -50 -27 -16 -33 -35   0 -26 142\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
-22   0 -05 -28 -27  51 -40  22 -07   0 -21   0 -02 -14   0 -31 -17 -18 -19 -19   0 -11  41   0  78\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0";

const char *GRIBSKOW_MAT =
"Name: Gribskow Matrix\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
  15\n\
   2  11\n\
   3  -4  15\n\
   3  11  -5  15\n\
   3   7  -6  10  15\n\
  -5  -7  -1 -10  -7  15\n\
   7   6   2   7   5  -6  15\n\
  -1   4  -1   4   4  -1  -2  15\n\
   0  -2   2  -2  -2   7  -3  -3  15\n\
   0   0   0   0   0   0   0   0   0   0\n\
   0   4  -6   3   3  -7  -1   1  -2   0  15\n\
  -1  -5  -8  -5  -3  12  -5  -2   8   0  -3  15\n\
   0  -3  -6  -4  -2   5  -3  -3   6   0   2  13  15\n\
   2  11  -3   7   5  -5   4   5  -3   0   4  -4  -3  15\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
   5   1   1   1   1  -7   3   2  -2   0   1  -3  -2   0   0  15\n\
   2   5  -6   7   7  -8   2   7  -3   0   4  -1   0   4   0   3  15\n\
  -3   1  -3   0   0  -5  -3   5  -3   0   8  -4   2   1   0   3   4  15\n\
   4   3   7   2   2  -3   6  -2  -1   0   2  -4  -3   3   0   4  -1   1  15\n\
   4   2   2   2   2  -3   4  -1   2   0   2  -1   0   2   0   3  -1  -1   3  15\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
   2  -2   2  -2  -2   2   2  -3  11   0  -2   8   6  -3   0   1  -2  -3  -1   2   0  15\n\
  -8  -7 -12 -11 -11  13 -10  -1  -5   0   1   5  -3  -3   0  -8  -5  14   3  -6   0  -8  15\n\
   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
  -3  -3  10  -5  -5  14  -7   3   1   0  -6   3  -1  -1   0  -8  -6  -6  -4  -3   0  -1  11   0  15\n\
   2   6  -6   9  11  -7   3   5  -2   0   4  -2  -1   4   0   2  11   2   0   1   0  -2  -8   0  -6  11";

const char *MCCLURE_MAT =
"Name: Conservative Substitutions\n\
# (A,G) (C) (D,E) (F,Y) (H) (I,L,M,V) (K,R) (N,Q) (S,T)\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
  1\n\
  0   0\n\
 -1   0   1\n\
 -1   0  -1   1\n\
 -1   0  -1   1   1\n\
 -1   0  -1  -1  -1   1\n\
  1   0  -1  -1  -1  -1   1\n\
 -1   0  -1  -1  -1  -1  -1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1   1\n\
  0   0   0   0   0   0   0   0   0   0\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0   1\n\
 -1   0  -1  -1  -1  -1  -1  -1   1   0  -1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1   1   0  -1   1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1   1\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1  -1   0   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1   1   0  -1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0   1  -1  -1  -1   0  -1  -1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1  -1   0  -1  -1  -1   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1  -1   0  -1  -1  -1   1   1\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
 -1   0  -1  -1  -1  -1  -1  -1   1   0  -1   1   1  -1   0  -1  -1  -1  -1  -1   0   1\n\
 -1   0  -1  -1  -1  -1  -1  -1  -1   0  -1  -1  -1  -1   0  -1  -1  -1  -1  -1   0  -1   1\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0\n\
 -1   0  -1  -1  -1   1  -1  -1  -1   0  -1  -1  -1  -1   0  -1  -1  -1  -1  -1   0  -1  -1   0   1\n\
  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0";

const char *TAYLOR_MAT =
"Name: Taylor's Matrix\n\
Case Sensitive:N\n\
Alphabet: ABCDEFGHIJKLMNOPQRSTUVWXYZ\n\
8\n\
4 6\n\
6 4 8\n\
3 6 3 8\n\
1 5 2 6 8\n\
4 2 5 1 2 8\n\
7 3 6 2 1 4 8\n\
1 2 2 2 3 4 1 8\n\
4 2 5 1 2 5 4 2 8\n\
0 0 0 0 0 0 0 0 0 0\n\
2 3 3 3 4 3 2 6 3 0 8\n\
4 2 5 1 2 5 4 2 7 0 3 8\n\
5 3 6 2 3 6 5 3 6 0 4 6 8\n\
4 6 5 5 4 3 4 2 3 0 3 3 4 8\n\
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n\
4 4 5 3 2 3 4 0 3 0 1 3 4 5 0 8\n\
3 5 4 4 5 4 3 3 4 0 4 4 5 6 0 4 8\n\
1 4 2 4 5 2 1 5 2 0 6 2 3 4 0 2 5 8\n\
5 5 4 4 3 2 5 1 2 0 2 2 3 6 0 4 5 3 8\n\
5 5 6 4 3 4 5 3 4 0 4 4 5 6 0 4 5 3 5 8\n\
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n\
5 3 6 2 1 4 5 1 6 0 2 6 5 4 0 4 3 1 3 5 0 8\n\
3 3 4 2 3 6 3 5 4 0 4 4 5 4 0 2 5 3 3 5 0 3 8\n\
4 4 5 3 3 4 4 3 4 0 4 4 5 4 0 3 4 3 4 5 0 4 4 4\n\
3 3 4 2 3 6 3 5 4 0 4 4 5 4 0 2 5 3 3 5 0 3 7 4 8\n\
2 5 3 5 6 3 2 3 3 0 4 3 4 5 0 3 6 5 4 4 0 2 4 4 4 6";


