/*
**++
**  FACILITY:  University of California, Davis
**              Computer Science Department
**              Theory Lab
**
**  PROGRAM NAME:       XPARAL
**
**  MODULE DESCRIPTION:
**
**      This file contains the routine that calls the appropriate
**      function for performing the dynamic string matching.
**      (Different routines are called for constant costs
**      than for costs from a weight table).
**
*/

#include "header.h"
#include "globals_s.h"
#include "dynam_conv.h"

/*******************************************************************/
/* Determines and sets the optimal value and alignment path.flag.  */
/* for a cell based on the possible values.                        */
/* (based on match, mismatch, insert, delete).                     */
/*******************************************************************/
void     set_optimal(    Max_node        *curr,
			 double          diag_val,
			 double          side_val,
			 double          top_val)
{
    if  (   (diag_val >= side_val)
         || (equal(diag_val, side_val)))
    {
        if  (   (diag_val >= top_val)
             || (equal(diag_val, top_val)))
        {
            //  (diagonal is optimal)
            curr->value = diag_val;
            curr->path.flag.diag_opt = 1;
            if  (   (side_val == diag_val)
                 || (equal(side_val, diag_val)))
                curr->path.flag.side_opt = 1;
            if  (   (top_val == diag_val)
                 || (equal(top_val, diag_val)))
                curr->path.flag.top_opt = 1;
        }
        else //  => (top_val > diag_val >= side_val),
        {
            //  (top is optimal)
            curr->value = top_val;
            curr->path.flag.top_opt = 1;
        }
    }
    else //  => (diagonal is not optimal)
    if  (   (side_val >= top_val)
         || (equal(side_val, top_val)))
    {
        //  (side is optimal)
        curr->value = side_val;
        curr->path.flag.side_opt = 1;
        if  (   (top_val == side_val)
             || (equal(top_val, side_val)))
            curr->path.flag.top_opt = 1;
    }
    else //  => (side is not optimal)
    {
        //  (top is optimal)
        curr->value = top_val;
        curr->path.flag.top_opt = 1;
    }
}

/*******************************************************************/
/* Determines and sets the optimal value and alignment path.flag.  */
/* for a cell based on the possible values.                        */
/* (based on match, mismatch, insert, delete).                     */
/*******************************************************************/
void     set_optimal_fast(    Max_node        *curr,
			      double          diag_val,
			      double          side_val,
			      double          top_val)
{
    if  (diag_val >= side_val)
    {
        if  (diag_val >= top_val)
        {
            //  (diagonal is optimal)
            curr->value = diag_val;
            curr->path.flag.diag_opt = 1;
        }
        else //  => (top_val > diag_val >= side_val),
        {
            //  (top is optimal)
            curr->value = top_val;
            curr->path.flag.top_opt = 1;
        }
    }
    else //  => (diagonal is not optimal)
    if  (side_val >= top_val)
    {
        //  (side is optimal)
        curr->value = side_val;
        curr->path.flag.side_opt = 1;
    }
    else //  => (side is not optimal)
    {
        //  (top is optimal)
        curr->value = top_val;
        curr->path.flag.top_opt = 1;
    }
}

/* stack routines for the log implementation of convex gaps */

void lpush(int b, int p, int *lsp, lpoint *lst)
{
     lst[*lsp].p = p;
     lst[*lsp].b = b;
     (*lsp)++;
}

lpoint lpop(int *lsp, lpoint *lst)
{
	(*lsp)--;
	return lst[*lsp];
}

lpoint read_pt(int *lsp, lpoint *lst)
{
	return lst[(*lsp)-1];
}

int list_empty(int *lsp, lpoint *lst)
{
	return ( (*lsp)==0 );
}

#define AM(a,row,column)  ((a)+((row)*(len2+1))+(column))

double candrow(int x, int y, const int i, const int j, const Point *pt)
{
  Max_node *temp;
  double temp_val;
  
  temp=AM(array,i,x);
  temp_val=temp->value;
  temp_val+=( pt->y * WEIGHT_INORDEL_CONV(y-x) );
  temp_val+=( pt->w * WEIGHT_GAP_CONV );
  
  return(temp_val);
}

double candcol(int x, int y, const int i, const int j, const Point *pt)
{
  Max_node *temp;
  double temp_val;
  
  temp=AM(array,x,j);
  temp_val=temp->value;
  temp_val+=( pt->y * WEIGHT_INORDEL_CONV(y-x) );
  temp_val+=( pt->w * WEIGHT_GAP_CONV );
  
  return(temp_val);
}          

#undef AM
