/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -p -j1 -i 1 -g -o -t -G -N is_reserved_word -k1,3,$  */
/* Command-line: gperf -p -j1 -i 1 -g -o -t -N is_reserved_word -k1,3,$ c-parse.gperf  */ 
struct resword { char *name; short token; enum rid rid; };

#define TOTAL_KEYWORDS 65
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 16
#define MIN_HASH_VALUE 13
#define MAX_HASH_VALUE 139
/* maximum key range = 127, duplicates = 0 */

#ifdef __GNUC__
inline
#endif
static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
     140, 140, 140, 140, 140,   1, 140,  12,  15,  24,
      28,   8,  30,  21,  12,  14, 140,   1,  19,  27,
      34,  53,  30, 140,  50,   2,   1,  42,  36,   1,
       7, 140,  10, 140, 140, 140, 140, 140,
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 3:
        hval += asso_values[str[2]];
      case 2:
      case 1:
        hval += asso_values[str[0]];
        break;
    }
  return hval + asso_values[str[len - 1]];
}

static struct resword wordlist[] =
{
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, 
      {"__typeof__",  TYPEOF, NORID},
      {"__signed__",  TYPESPEC, RID_SIGNED},
      {"",}, {"",}, {"",}, {"",}, 
      {"int",  TYPESPEC, RID_INT},
      {"",}, 
      {"__asm__",  ASM_KEYWORD, NORID},
      {"else",  ELSE, NORID},
      {"__extension__",  EXTENSION, NORID},
      {"__imag__",  IMAGPART, NORID},
      {"__alignof__",  ALIGNOF, NORID},
      {"__inline__",  SCSPEC, RID_INLINE},
      {"__attribute__",  ATTRIBUTE, NORID},
      {"while",  WHILE, NORID},
      {"break",  BREAK, NORID},
      {"__label__",  LABEL, NORID},
      {"__inline",  SCSPEC, RID_INLINE},
      {"__attribute",  ATTRIBUTE, NORID},
      {"__const",  TYPE_QUAL, const_qualifier},
      {"switch",  SWITCH, NORID},
      {"__const__",  TYPE_QUAL, const_qualifier},
      {"",}, 
      {"__complex__",  TYPESPEC, RID_COMPLEX},
      {"case",  CASE, NORID},
      {"__signed",  TYPESPEC, RID_SIGNED},
      {"__typeof",  TYPEOF, NORID},
      {"__complex",  TYPESPEC, RID_COMPLEX},
      {"__imag",  IMAGPART, NORID},
      {"traditional",  TYPE_QUAL, traditional_qualifier},
      {"static",  SCSPEC, RID_STATIC},
      {"__asm",  ASM_KEYWORD, NORID},
      {"if",  IF, NORID},
      {"inline",  SCSPEC, RID_INLINE},
      {"sizeof",  SIZEOF, NORID},
      {"extern",  SCSPEC, RID_EXTERN},
      {"__volatile__",  TYPE_QUAL, volatile_qualifier},
      {"",}, 
      {"__alignof",  ALIGNOF, NORID},
      {"__builtin_va_arg",  VA_ARG, NORID},
      {"",}, 
      {"__volatile",  TYPE_QUAL, volatile_qualifier},
      {"deletes",  FN_QUAL, deletes_qualifier},
      {"signed",  TYPESPEC, RID_SIGNED},
      {"",}, 
      {"struct",  STRUCT, NORID},
      {"__real__",  REALPART, NORID},
      {"short",  TYPESPEC, RID_SHORT},
      {"__restrict",  TYPE_QUAL, restrict_qualifier},
      {"",}, 
      {"const",  TYPE_QUAL, const_qualifier},
      {"",}, 
      {"default",  DEFAULT, NORID},
      {"typeof",  TYPEOF, NORID},
      {"typedef",  SCSPEC, RID_TYPEDEF},
      {"asm",  ASM_KEYWORD, NORID},
      {"auto",  SCSPEC, RID_AUTO},
      {"volatile",  TYPE_QUAL, volatile_qualifier},
      {"",}, 
      {"sameregion",  TYPE_QUAL, sameregion_qualifier},
      {"continue",  CONTINUE, NORID},
      {"",}, 
      {"__real",  REALPART, NORID},
      {"",}, 
      {"long",  TYPESPEC, RID_LONG},
      {"goto",  GOTO, NORID},
      {"unsigned",  TYPESPEC, RID_UNSIGNED},
      {"enum",  ENUM, NORID},
      {"void",  TYPESPEC, RID_VOID},
      {"do",  DO, NORID},
      {"double",  TYPESPEC, RID_DOUBLE},
      {"",}, {"",}, {"",}, {"",}, 
      {"float",  TYPESPEC, RID_FLOAT},
      {"char",  TYPESPEC, RID_CHAR},
      {"return",  RETURN, NORID},
      {"",}, {"",}, {"",}, 
      {"union",  UNION, NORID},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"register",  SCSPEC, RID_REGISTER},
      {"",}, {"",}, {"",}, 
      {"for",  FOR, NORID},
      {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"parentptr",  TYPE_QUAL, parentptr_qualifier},
};

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word (str, len)
     register char *str;
     register unsigned int len;
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
