// $Id: Bin2Text.java,v 1.6 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import gnu.getopt.*;

public class Bin2Text
{
  static final String optionString = "i:o:" + Util.getOptionString(),
    optionUsage =
    "Usage: Bin2Text [options]\n" +
    "  -i <file>\tRead input from <file>\n" +
    "  -o <file>\tWrite output to <file>\n" +
    Util.getOptionUsage();

  public static void main(String[] args) throws IOException
  {
    Getopt opt;
    int ch;
    String inputFileName = "-", outputFileName = "-";
    
    opt = new Getopt("Bin2Text", args, optionString, Util.getLongOpts());
    while ((ch = opt.getopt()) != -1)
    {
      switch(ch)
      {
	case 'i':
	  inputFileName = opt.getOptarg();
	  break;

	case 'o':
	  outputFileName = opt.getOptarg();
	  break;
	  
	default:
	  Util.processOption(ch, opt, optionUsage);
      }
    }
    if ((args.length - opt.getOptind()) != 0)
    {
      Util.stderr.println(optionUsage);
      System.exit(1);
    }
    run(inputFileName, outputFileName);
  }

  static void run(String inputFilename, String outputFilename)
    throws IOException
  {
    BinaryInput input;
    TextOutput output;
    int token;

    input = new BinaryInput(
      new BufferedInputStream(Util.openInputStream(inputFilename)),
      inputFilename);
    output = new TextOutput(new PrintWriter(Util.openWriter(outputFilename)));

    for (token = input.nextToken();
	 input.isOk();
	 token = input.nextToken())
    {
      switch(token)
      {
	case Constants.BYTE:
	  output.writeByte(input.byteValue());
	  break;

	case Constants.INT:
	  output.writeInt(input.intValue());
	  break;

	case Constants.STRING:
	  output.writeString(input.stringValue());
	  break;

	default:
	  if (token < 0 || token > Constants.MAX_TOKEN)
	  {
	    // should not call output.close(), because output may be
	    // System.out, to which we need to print error message.
	    output.flush();
	    Util.stderr.println("Token out of range: " + token +
	      ".  Maybe " + inputFilename + " is not a MOPS binary file?");
	    System.exit(0);
	  }
	  output.writeToken(token);
      }
    }

    output.flush();
    output.close();
  }
}
