// $Id: BinaryInput.java,v 1.5 2003/06/10 19:37:34 hchen Exp $

// It was a mistake for this file to suppress input failures by returning 
// a premature EOF. Instead, it should encode an explicit EOF and throw()
// in cases where the file terminates prematurely.
import java.io.*;

class BinaryInput extends Input
{
  public BinaryInput(InputStream is, String filename)
  {
    super(filename);
    this.dis = new DataInputStream(is);

    lineNumber = 1;
    token = -1;
  }

  // Return any token value
  public int nextToken() throws IOException
  {
    try
    {
      return nextToken0();
    }
    catch(EOFException e)
    {
      eof = true;
    }
    return -1;
  }

  public final int nextToken0() throws IOException
  {
    conversionOk = true;
    tokenOk = false;
    token = (int) (dis.readByte() & 0xff);
    if (token > Constants.MAX_TOKEN)
    {
      tokenOk = true;
      return token;
    }
    switch(token)
    {
      case Constants.BYTE:
	intValue = (int) (dis.readByte() & 0xff);
	break;

      case Constants.INT:
	intValue = dis.readInt();
	break;

      case Constants.STRING:
	{
	  int length, i;
	  byte[] buffer;

	  length = dis.readInt();
	  buffer = new byte[length];

	  // Util.warn(Util.WARNING, "reading " + length + " bytes");

	  for (i = 0; i < length; i++)
	    buffer[i] = dis.readByte();

	  stringValue = new String(buffer, 0, length);
	}
	break;

      case Constants.EOL:
	lineNumber++;
	break;
    }

    tokenOk = true;
    return token;
  }

  // Returns the same as nextToken()
  public int tokenValue()
  {
    conversionOk = true;
    return token;
  }
  
  public int byteValue()
  {
    conversionOk = (token == Constants.BYTE);
    return intValue;
  }

  public int intValue()
  {
    conversionOk = (token == Constants.INT);
    return intValue;
  }

  public String stringValue()
  {
    conversionOk = (token == Constants.STRING);
    return stringValue;
  }

  public int getLineNumber()
  {
    return lineNumber;
  }

  public void close() throws IOException
  {
    dis.close();
  }
  
  DataInputStream dis;

  int intValue;
  String stringValue;
  int token;
  int lineNumber;
}
