// $Id: Edge.java,v 1.4 2003/09/22 21:31:56 hchen Exp $

import java.io.*;
import java.util.*;

/**
 * Represent an Edge in the CFG
 */
public class Edge implements EdgeBase
{
  public Edge()
  {
    setLabel(null);
  }

  public final void setLabel(Ast label)
  {
    this.label = label;
  }

  public final Ast getLabel()
  {
    return label;
  }

  /**
   * The AST on this edge
   */
  protected Ast label;

  // fake multiple inheritance
  // begin interface EdgeBase
  protected final void EdgeBase(NodeBase srcNode, NodeBase dstNode)
  {
    if (srcNode != null && dstNode != null)
      setNodes(srcNode, dstNode);
  }
  
  public final void setSrcNode(NodeBase srcNode)
  {
    this.srcNode = srcNode;
  }

  public final void setDstNode(NodeBase dstNode)
  {
    this.dstNode = dstNode;
  }
  
  public final NodeBase getSrcNode()
  {
    return srcNode;
  }

  public final NodeBase getDstNode()
  {
    return dstNode;
  }

  public final void setNodes(NodeBase srcNode, NodeBase dstNode)
  {
    this.srcNode = srcNode;
    this.dstNode = dstNode;
    srcNode.getOutEdges().add(this);
    dstNode.getInEdges().add(this);
  }

  NodeBase srcNode, dstNode;
  // end interface EdgeBase
}
