// $Id: ExplicitEdge.java,v 1.2 2003/07/25 18:12:29 hchen Exp $

public class ExplicitEdge
{
  public ExplicitEdge()
  {
    srcNode = new FsaTransition();
    dstNode = new FsaTransition();
  }
  
  public ExplicitEdge(FsaTransition srcNode, FsaTransition dstNode)
  {
    this.srcNode =
      new FsaTransition(srcNode.state0, srcNode.input, srcNode.state1);
    this.dstNode =
      new FsaTransition(dstNode.state0, dstNode.input, dstNode.state1);
  }

  public boolean equals(Object object)
  {
    ExplicitEdge edge = (ExplicitEdge)object;
    
    return srcNode.equals(edge.srcNode) && dstNode.equals(edge.dstNode);
  }

  public int hashCode()
  {
    final int shift = 5, mask = (int)1L << shift - 1;
    
    return
      /*
      Util.remainder(srcNode.state0, modulo)) * modulo
	  + Util.remainder(srcNode.input.hashCode(), modulo)) * modulo
	 + Util.remainder(srcNode.state1, modulo)) * modulo
	+ Util.remainder(dstNode.state0, modulo)) * modulo
       + Util.remainder(dstNode.input.hashCode(), modulo)) * modulo
      + Util.remainder(dstNode.state1, modulo);
      */
      (((((((((
	       (srcNode.state0 & mask) << shift) +
	      (srcNode.input.hashCode() & mask)) << shift) +
	    (srcNode.state1 & mask)) << shift) +
	  (dstNode.state0 & mask)) << shift) +
	(dstNode.input.hashCode() & mask)) << shift) +
      (dstNode.state1 & mask);
  }

  FsaTransition srcNode, dstNode;
}
